/*
 * Decompiled with CFR 0.152.
 */
package littlechasiu.ctm;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import littlechasiu.ctm.Server;
import littlechasiu.ctm.TrackWatcher;
import littlechasiu.ctm.model.BlockStatus;
import littlechasiu.ctm.model.Config;
import littlechasiu.ctm.model.Network;
import littlechasiu.ctm.model.SignalStatus;
import littlechasiu.ctm.model.TrainStatus;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003R\u0014\u0010\t\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\f\n\u0004\b\u000b\u0010\n\u0012\u0004\b\f\u0010\u0003R\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0019\u001a\u00020\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0011\u0010#\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010'\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010+\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010/\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R*\u00108\u001a\b\u0012\u0004\u0012\u00028\u000005\"\u0004\b\u0000\u00103*\b\u0012\u0004\u0012\u00028\u0000048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u001d\u00109\u001a\b\u0012\u0004\u0012\u00020 058\u0006\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<R\u001d\u0010=\u001a\b\u0012\u0004\u0012\u00020$058\u0006\u00a2\u0006\f\n\u0004\b=\u0010:\u001a\u0004\b>\u0010<R\u001d\u0010?\u001a\b\u0012\u0004\u0012\u00020(058\u0006\u00a2\u0006\f\n\u0004\b?\u0010:\u001a\u0004\b@\u0010<R\u001d\u0010A\u001a\b\u0012\u0004\u0012\u00020,058\u0006\u00a2\u0006\f\n\u0004\bA\u0010:\u001a\u0004\bB\u0010<\u00a8\u0006C"}, d2={"Llittlechasiu/ctm/TrackMap;", "", "<init>", "()V", "", "loadConfig", "reload", "init", "", "MODID", "Ljava/lang/String;", "configFileName", "getConfigFileName$annotations", "Lkotlinx/serialization/json/Json;", "JSON", "Lkotlinx/serialization/json/Json;", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "Llittlechasiu/ctm/model/Config;", "config", "Llittlechasiu/ctm/model/Config;", "Llittlechasiu/ctm/TrackWatcher;", "watcher", "Llittlechasiu/ctm/TrackWatcher;", "getWatcher", "()Llittlechasiu/ctm/TrackWatcher;", "Llittlechasiu/ctm/Server;", "server", "Llittlechasiu/ctm/Server;", "Llittlechasiu/ctm/model/Network;", "getNetwork", "()Llittlechasiu/ctm/model/Network;", "network", "Llittlechasiu/ctm/model/SignalStatus;", "getSignals", "()Llittlechasiu/ctm/model/SignalStatus;", "signals", "Llittlechasiu/ctm/model/BlockStatus;", "getBlocks", "()Llittlechasiu/ctm/model/BlockStatus;", "blocks", "Llittlechasiu/ctm/model/TrainStatus;", "getTrains", "()Llittlechasiu/ctm/model/TrainStatus;", "trains", "Lkotlinx/coroutines/CoroutineScope;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "T", "Lkotlinx/coroutines/channels/Channel;", "Lkotlinx/coroutines/flow/SharedFlow;", "getFlow", "(Lkotlinx/coroutines/channels/Channel;)Lkotlinx/coroutines/flow/SharedFlow;", "flow", "networkFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "getNetworkFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "signalFlow", "getSignalFlow", "blockFlow", "getBlockFlow", "trainFlow", "getTrainFlow", "CTM-Restitched"})
@SourceDebugExtension(value={"SMAP\nTrackMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackMap.kt\nlittlechasiu/ctm/TrackMap\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n*L\n1#1,122:1\n80#2:123\n42#2:124\n*S KotlinDebug\n*F\n+ 1 TrackMap.kt\nlittlechasiu/ctm/TrackMap\n*L\n63#1:123\n67#1:124\n*E\n"})
public final class TrackMap {
    @NotNull
    public static final TrackMap INSTANCE = new TrackMap();
    @NotNull
    public static final String MODID = "create-track-map";
    @NotNull
    private static final String configFileName = "create-track-map.json";
    @NotNull
    private static final Json JSON = JsonKt.Json$default(null, TrackMap::JSON$lambda$0, 1, null);
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static Config config;
    @NotNull
    private static final TrackWatcher watcher;
    @NotNull
    private static final Server server;
    @NotNull
    private static final CoroutineScope scope;
    @NotNull
    private static final SharedFlow<Network> networkFlow;
    @NotNull
    private static final SharedFlow<SignalStatus> signalFlow;
    @NotNull
    private static final SharedFlow<BlockStatus> blockFlow;
    @NotNull
    private static final SharedFlow<TrainStatus> trainFlow;

    private TrackMap() {
    }

    private static /* synthetic */ void getConfigFileName$annotations() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public final TrackWatcher getWatcher() {
        return watcher;
    }

    @NotNull
    public final Network getNetwork() {
        return watcher.getNetwork();
    }

    @NotNull
    public final SignalStatus getSignals() {
        return watcher.getSignalStatus();
    }

    @NotNull
    public final BlockStatus getBlocks() {
        return watcher.getBlockStatus();
    }

    @NotNull
    public final TrainStatus getTrains() {
        return watcher.getTrainStatus();
    }

    private final <T> SharedFlow<T> getFlow(Channel<T> $this$flow) {
        return FlowKt.shareIn$default((Flow)FlowKt.distinctUntilChanged((Flow)FlowKt.consumeAsFlow((ReceiveChannel)((ReceiveChannel)$this$flow))), (CoroutineScope)scope, (SharingStarted)SharingStarted.Companion.getEagerly(), (int)0, (int)4, null);
    }

    @NotNull
    public final SharedFlow<Network> getNetworkFlow() {
        return networkFlow;
    }

    @NotNull
    public final SharedFlow<SignalStatus> getSignalFlow() {
        return signalFlow;
    }

    @NotNull
    public final SharedFlow<BlockStatus> getBlockFlow() {
        return blockFlow;
    }

    @NotNull
    public final SharedFlow<TrainStatus> getTrainFlow() {
        return trainFlow;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadConfig() {
        try {
            Path configFile = FabricLoader.getInstance().getConfigDir().resolve(configFileName);
            if (Files.exists(configFile, new LinkOption[0])) {
                void $this$decodeFromStream$iv;
                Json json = JSON;
                InputStream inputStream = Files.newInputStream(configFile, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                InputStream stream$iv2 = inputStream;
                boolean $i$f$decodeFromStream = false;
                $this$decodeFromStream$iv.getSerializersModule();
                config = (Config)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)Config.Companion.serializer(), stream$iv2);
            } else {
                void stream$iv;
                void value$iv;
                void $this$encodeToStream$iv;
                LOGGER.warn("Create Track Map config does not exist, writing defaults to create-track-map.json");
                config = new Config(false, 0.0, 0, null, null, null, null, 127, null);
                Json $this$decodeFromStream$iv = JSON;
                Config stream$iv2 = config;
                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
                OutputStream outputStream = Files.newOutputStream(configFile, openOptionArray);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                OutputStream $i$f$decodeFromStream = outputStream;
                boolean $i$f$encodeToStream = false;
                $this$encodeToStream$iv.getSerializersModule();
                JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv, (SerializationStrategy)Config.Companion.serializer(), value$iv, (OutputStream)stream$iv);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error loading Create Track Map config, using defaults");
            e.printStackTrace();
            config = new Config(false, 0.0, 0, null, null, null, null, 127, null);
        }
        watcher.setEnable(config.getEnable());
        server.setEnable(config.getEnable());
        watcher.setWatchInterval-LRDsOJo(DurationKt.toDuration((double)config.getWatchIntervalSeconds(), (DurationUnit)DurationUnit.SECONDS));
        server.setPort(config.getServerPort());
        server.setMapStyle(config.getMapStyle());
        server.setMapView(config.getMapView());
        server.setDimensions(config.getDimensions());
        server.setLayers(config.getLayers());
    }

    private final void reload() {
        watcher.stop();
        server.stop();
        this.loadConfig();
        watcher.start();
        server.start();
    }

    public final void init() {
        this.loadConfig();
        CommandRegistrationCallback.EVENT.register(TrackMap::init$lambda$3);
        ServerLifecycleEvents.SERVER_STARTED.register(TrackMap::init$lambda$4);
        ServerLifecycleEvents.SERVER_STOPPING.register(TrackMap::init$lambda$5);
    }

    private static final Unit JSON$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setLenient(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setPrettyPrint(true);
        $this$Json.setPrettyPrintIndent("  ");
        return Unit.INSTANCE;
    }

    private static final boolean init$lambda$3$lambda$1(class_2168 src) {
        return src.method_9259(4);
    }

    private static final int init$lambda$3$lambda$2(CommandContext commandContext) {
        INSTANCE.reload();
        return 1;
    }

    private static final void init$lambda$3(CommandDispatcher disp, class_7157 class_71572, class_2170.class_5364 class_53642) {
        disp.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ctm").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(TrackMap::init$lambda$3$lambda$1)).executes(TrackMap::init$lambda$3$lambda$2)));
    }

    private static final void init$lambda$4(MinecraftServer it) {
        watcher.start();
        server.start();
    }

    private static final void init$lambda$5(MinecraftServer it) {
        watcher.stop();
        server.stop();
    }

    static {
        Logger logger = LogManager.getLogger((String)MODID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        config = new Config(false, 0.0, 0, null, null, null, null, 127, null);
        watcher = new TrackWatcher();
        server = new Server();
        scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        networkFlow = INSTANCE.getFlow(watcher.getNetworkChannel());
        signalFlow = INSTANCE.getFlow(watcher.getSignalChannel());
        blockFlow = INSTANCE.getFlow(watcher.getBlockChannel());
        trainFlow = INSTANCE.getFlow(watcher.getTrainChannel());
    }
}

