/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNamingStrategy;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0012\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b!\u0010\"R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010%R\u0016\u0010\t\u001a\u0004\u0018\u00010\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010&R\u0016\u0010'\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lkotlinx/serialization/json/internal/JsonTreeDecoder;", "Lkotlinx/serialization/json/internal/AbstractJsonTreeDecoder;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/JsonObject;", "value", "", "polymorphicDiscriminator", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "polyDescriptor", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "descriptor", "", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "index", "", "setForceNull", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Z", "decodeNotNullMark", "()Z", "elementName", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Ljava/lang/String;", "tag", "Lkotlinx/serialization/json/JsonElement;", "currentElement", "(Ljava/lang/String;)Lkotlinx/serialization/json/JsonElement;", "currentElementOrNull", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "", "endStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "Lkotlinx/serialization/json/JsonObject;", "getValue", "()Lkotlinx/serialization/json/JsonObject;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "position", "I", "forceNull", "Z", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nTreeJsonDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeJsonDecoder.kt\nkotlinx/serialization/json/internal/JsonTreeDecoder\n+ 2 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 TreeJsonDecoder.kt\nkotlinx/serialization/json/internal/AbstractJsonTreeDecoder\n+ 5 TreeJsonEncoder.kt\nkotlinx/serialization/json/internal/TreeJsonEncoderKt\n*L\n1#1,348:1\n133#2,18:349\n1#3:367\n73#4:368\n270#5,8:369\n*S KotlinDebug\n*F\n+ 1 TreeJsonDecoder.kt\nkotlinx/serialization/json/internal/JsonTreeDecoder\n*L\n212#1:349,18\n271#1:368\n271#1:369,8\n*E\n"})
class JsonTreeDecoder
extends AbstractJsonTreeDecoder {
    @NotNull
    private final JsonObject value;
    @Nullable
    private final SerialDescriptor polyDescriptor;
    private int position;
    private boolean forceNull;

    public JsonTreeDecoder(@NotNull Json json, @NotNull JsonObject value, @Nullable String polymorphicDiscriminator, @Nullable SerialDescriptor polyDescriptor) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(json, value, polymorphicDiscriminator, null);
        this.value = value;
        this.polyDescriptor = polyDescriptor;
    }

    public /* synthetic */ JsonTreeDecoder(Json json, JsonObject jsonObject, String string, SerialDescriptor serialDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            serialDescriptor = null;
        }
        this(json, jsonObject, string, serialDescriptor);
    }

    @Override
    @NotNull
    public JsonObject getValue() {
        return this.value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        while (this.position < descriptor.getElementsCount()) {
            block10: {
                block9: {
                    var3_3 = this.position;
                    this.position = var3_3 + 1;
                    name = this.getTag(descriptor, var3_3);
                    index = this.position - 1;
                    this.forceNull = false;
                    if (!((Map)this.getValue()).containsKey(name) && !this.setForceNull(descriptor, index)) continue;
                    if (!this.configuration.getCoerceInputValues()) {
                        return index;
                    }
                    $this$tryCoerceValue$iv = this.getJson();
                    $i$f$tryCoerceValue = false;
                    isOptional$iv = descriptor.isElementOptional(index);
                    elementDescriptor$iv = descriptor.getElementDescriptor(index);
                    if (!isOptional$iv || elementDescriptor$iv.isNullable()) break block9;
                    it = true;
                    $i$a$-tryCoerceValue-JsonTreeDecoder$decodeElementIndex$1 = false;
                    if (!(this.currentElementOrNull(name) instanceof JsonNull)) break block9;
                    v0 = true;
                    break block10;
                }
                if (!Intrinsics.areEqual((Object)elementDescriptor$iv.getKind(), (Object)SerialKind.ENUM.INSTANCE)) ** GOTO lbl-1000
                if (!elementDescriptor$iv.isNullable()) ** GOTO lbl-1000
                it = false;
                $i$a$-tryCoerceValue-JsonTreeDecoder$decodeElementIndex$1 = false;
                if (this.currentElementOrNull(name) instanceof JsonNull) {
                    v0 = false;
                } else lbl-1000:
                // 2 sources

                {
                    $i$a$-tryCoerceValue-JsonTreeDecoder$decodeElementIndex$2 = false;
                    var9_10 = this.currentElementOrNull(name);
                    v1 = var9_10 instanceof JsonPrimitive != false ? (JsonPrimitive)var9_10 : null;
                    if ((v1 != null ? JsonElementKt.getContentOrNull(v1) : null) == null) {
                        v0 = false;
                    } else {
                        enumValue$iv = enumValue$iv;
                        enumIndex$iv = JsonNamesMapKt.getJsonNameIndex(elementDescriptor$iv, $this$tryCoerceValue$iv, enumValue$iv);
                        v2 = coerceToNull$iv = $this$tryCoerceValue$iv.getConfiguration().getExplicitNulls() == false && elementDescriptor$iv.isNullable() != false;
                        if (enumIndex$iv == -3 && (isOptional$iv || coerceToNull$iv)) {
                            $i$a$-tryCoerceValue-JsonTreeDecoder$decodeElementIndex$3 = false;
                            if (this.setForceNull(descriptor, index)) {
                                return index;
                            }
                            v0 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v0 = false;
                        }
                    }
                }
            }
            if (v0) continue;
            return index;
        }
        return -1;
    }

    private final boolean setForceNull(SerialDescriptor descriptor, int index) {
        this.forceNull = !this.getJson().getConfiguration().getExplicitNulls() && !descriptor.isElementOptional(index) && descriptor.getElementDescriptor(index).isNullable();
        return this.forceNull;
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.forceNull && super.decodeNotNullMark();
    }

    @Override
    @NotNull
    protected String elementName(@NotNull SerialDescriptor descriptor, int index) {
        Object v1;
        String baseName;
        JsonNamingStrategy strategy;
        block6: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            strategy = JsonNamesMapKt.namingStrategy(descriptor, this.getJson());
            baseName = descriptor.getElementName(index);
            if (strategy == null) {
                if (!this.configuration.getUseAlternativeNames()) {
                    return baseName;
                }
                if (this.getValue().keySet().contains(baseName)) {
                    return baseName;
                }
            }
            Map<String, Integer> deserializationNamesMap = JsonNamesMapKt.deserializationNamesMap(this.getJson(), descriptor);
            Iterable iterable = this.getValue().keySet();
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                Integer n = deserializationNamesMap.get(it);
                int n2 = index;
                if (!(n != null && n == n2)) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        String string = v1;
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        JsonNamingStrategy jsonNamingStrategy = strategy;
        String fallbackName = jsonNamingStrategy != null ? jsonNamingStrategy.serialNameForJson(descriptor, index, baseName) : null;
        String string2 = fallbackName;
        if (string2 == null) {
            string2 = baseName;
        }
        return string2;
    }

    @Override
    @NotNull
    protected JsonElement currentElement(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return (JsonElement)MapsKt.getValue((Map)this.getValue(), (Object)tag);
    }

    @Nullable
    public final JsonElement currentElementOrNull(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return (JsonElement)this.getValue().get((Object)tag);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (descriptor == this.polyDescriptor) {
            void value$iv;
            AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
            JsonElement jsonElement = this.currentObject();
            SerialDescriptor descriptor$iv = this.polyDescriptor;
            boolean $i$f$cast = false;
            String serialName$iv$iv = descriptor$iv.getSerialName();
            boolean $i$f$cast2 = false;
            if (!(value$iv instanceof JsonObject)) {
                void this_$iv;
                StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv$iv).append(" at element: ");
                int n = -1;
                boolean bl = false;
                String string = AbstractJsonTreeDecoder.access$renderTagStack((AbstractJsonTreeDecoder)this_$iv);
                throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv.toString());
            }
            return new JsonTreeDecoder(this.getJson(), (JsonObject)value$iv, this.getPolymorphicDiscriminator(), this.polyDescriptor);
        }
        return super.beginStructure(descriptor);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (JsonNamesMapKt.ignoreUnknownKeys(descriptor, this.getJson()) || descriptor.getKind() instanceof PolymorphicKind) {
            return;
        }
        JsonNamingStrategy strategy = JsonNamesMapKt.namingStrategy(descriptor, this.getJson());
        if (strategy == null && !this.configuration.getUseAlternativeNames()) {
            set = JsonInternalDependenciesKt.jsonCachedSerialNames(descriptor);
        } else if (strategy != null) {
            set = JsonNamesMapKt.deserializationNamesMap(this.getJson(), descriptor).keySet();
        } else {
            Set<String> set2 = JsonInternalDependenciesKt.jsonCachedSerialNames(descriptor);
            Map<String, Integer> map2 = JsonSchemaCacheKt.getSchemaCache(this.getJson()).get(descriptor, JsonNamesMapKt.getJsonDeserializationNamesKey());
            Set set3 = map2 != null ? map2.keySet() : null;
            if (set3 == null) {
                set3 = SetsKt.emptySet();
            }
            set = SetsKt.plus(set2, (Iterable)set3);
        }
        Set names = set;
        for (String key : this.getValue().keySet()) {
            if (names.contains(key) || Intrinsics.areEqual((Object)key, (Object)this.getPolymorphicDiscriminator())) continue;
            throw JsonExceptionsKt.JsonDecodingException(-1, "Encountered an unknown key '" + key + "' at element: " + this.renderTagStack() + "\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder or '@JsonIgnoreUnknownKeys' annotation to ignore unknown keys.\nJSON input: " + JsonExceptionsKt.minify$default(this.getValue().toString(), 0, 1, null));
        }
    }
}

