/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.bytestring;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.ByteStringKt;
import kotlinx.io.bytestring.unsafe.UnsafeByteStringOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\u0006\u001a\u00020\u0000*\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0011\u0010\t\u001a\u00020\b*\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001b\u0010\r\u001a\u00020\u0000*\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000e\u001a!\u0010\r\u001a\u00020\u0000*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u0010\u001a\u0019\u0010\u0013\u001a\u00020\u0012*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a!\u0010\u0013\u001a\u00020\u0012*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0015\u001a#\u0010\u0017\u001a\u00020\u0012*\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lkotlinx/io/bytestring/ByteString;", "Ljava/nio/charset/Charset;", "charset", "", "decodeToString", "(Lkotlinx/io/bytestring/ByteString;Ljava/nio/charset/Charset;)Ljava/lang/String;", "encodeToByteString", "(Ljava/lang/String;Ljava/nio/charset/Charset;)Lkotlinx/io/bytestring/ByteString;", "Ljava/nio/ByteBuffer;", "asReadOnlyByteBuffer", "(Lkotlinx/io/bytestring/ByteString;)Ljava/nio/ByteBuffer;", "", "length", "getByteString", "(Ljava/nio/ByteBuffer;I)Lkotlinx/io/bytestring/ByteString;", "at", "(Ljava/nio/ByteBuffer;II)Lkotlinx/io/bytestring/ByteString;", "string", "", "putByteString", "(Ljava/nio/ByteBuffer;Lkotlinx/io/bytestring/ByteString;)V", "(Ljava/nio/ByteBuffer;ILkotlinx/io/bytestring/ByteString;)V", "idx", "checkIndexAndCapacity", "(Ljava/nio/ByteBuffer;II)V", "kotlinx-io-bytestring"})
@SourceDebugExtension(value={"SMAP\nByteStringJvmExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteStringJvmExt.kt\nkotlinx/io/bytestring/ByteStringJvmExtKt\n+ 2 UnsafeByteStringOperations.kt\nkotlinx/io/bytestring/unsafe/UnsafeByteStringOperations\n*L\n1#1,137:1\n42#2,2:138\n42#2,2:140\n*S KotlinDebug\n*F\n+ 1 ByteStringJvmExt.kt\nkotlinx/io/bytestring/ByteStringJvmExtKt\n*L\n37#1:138,2\n101#1:140,2\n*E\n"})
public final class ByteStringJvmExtKt {
    @NotNull
    public static final String decodeToString(@NotNull ByteString $this$decodeToString, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeToString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return new String($this$decodeToString.getBackingArrayReference(), charset);
    }

    @NotNull
    public static final ByteString encodeToByteString(@NotNull String $this$encodeToByteString, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeToByteString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        byte[] byArray = $this$encodeToByteString.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return ByteString.Companion.wrap$kotlinx_io_bytestring(byArray);
    }

    @NotNull
    public static final ByteBuffer asReadOnlyByteBuffer(@NotNull ByteString $this$asReadOnlyByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)$this$asReadOnlyByteBuffer, (String)"<this>");
        byte[] data = null;
        UnsafeByteStringOperations this_$iv = UnsafeByteStringOperations.INSTANCE;
        boolean $i$f$withByteArrayUnsafe = false;
        byte[] it = $this$asReadOnlyByteBuffer.getBackingArrayReference();
        boolean bl = false;
        data = it;
        ByteBuffer byteBuffer = ByteBuffer.wrap(data).asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"asReadOnlyBuffer(...)");
        return byteBuffer;
    }

    @NotNull
    public static final ByteString getByteString(@NotNull ByteBuffer $this$getByteString, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$getByteString, (String)"<this>");
        if (length < 0) {
            throw new IndexOutOfBoundsException("length should be non-negative (was " + length + ')');
        }
        if ($this$getByteString.remaining() < length) {
            throw new IndexOutOfBoundsException("length (" + length + ") exceeds remaining bytes count ({" + $this$getByteString.remaining() + "})");
        }
        byte[] bytes = new byte[length];
        $this$getByteString.get(bytes);
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(bytes);
    }

    public static /* synthetic */ ByteString getByteString$default(ByteBuffer byteBuffer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = byteBuffer.remaining();
        }
        return ByteStringJvmExtKt.getByteString(byteBuffer, n);
    }

    @NotNull
    public static final ByteString getByteString(@NotNull ByteBuffer $this$getByteString, int at, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$getByteString, (String)"<this>");
        ByteStringJvmExtKt.checkIndexAndCapacity($this$getByteString, at, length);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = $this$getByteString.get(at + i);
        }
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(bytes);
    }

    public static final void putByteString(@NotNull ByteBuffer $this$putByteString, @NotNull ByteString string) {
        Intrinsics.checkNotNullParameter((Object)$this$putByteString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        UnsafeByteStringOperations this_$iv = UnsafeByteStringOperations.INSTANCE;
        boolean $i$f$withByteArrayUnsafe = false;
        byte[] it = string.getBackingArrayReference();
        boolean bl = false;
        $this$putByteString.put(it);
    }

    public static final void putByteString(@NotNull ByteBuffer $this$putByteString, int at, @NotNull ByteString string) {
        Intrinsics.checkNotNullParameter((Object)$this$putByteString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        ByteStringJvmExtKt.checkIndexAndCapacity($this$putByteString, at, string.getSize());
        IntRange intRange = ByteStringKt.getIndices(string);
        int idx = intRange.getFirst();
        int n = intRange.getLast();
        if (idx <= n) {
            while (true) {
                $this$putByteString.put(at + idx, string.get(idx));
                if (idx == n) break;
                ++idx;
            }
        }
    }

    private static final void checkIndexAndCapacity(ByteBuffer $this$checkIndexAndCapacity, int idx, int length) {
        if (idx < 0 || idx >= $this$checkIndexAndCapacity.limit()) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of this ByteBuffer's bounds: [0, " + $this$checkIndexAndCapacity.limit() + ')');
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length should be non-negative (was " + length + ')');
        }
        if (idx + length > $this$checkIndexAndCapacity.limit()) {
            throw new IndexOutOfBoundsException("There's not enough space to put ByteString of length " + length + " starting from index " + idx);
        }
    }
}

