/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class CreateTaskAtMessage
extends BaseC2SMessage {
    private final long chapterId;
    private final double x;
    private final double y;
    private final TaskType type;
    private final class_2487 nbt;

    public CreateTaskAtMessage(Chapter chapter, double x, double y, Task task) {
        this.chapterId = chapter.id;
        this.x = x;
        this.y = y;
        this.type = task.getType();
        this.nbt = new class_2487();
        task.writeData(this.nbt);
    }

    CreateTaskAtMessage(class_2540 buffer) {
        this.chapterId = buffer.readLong();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.type = ServerQuestFile.INSTANCE.getTaskType(buffer.method_10816());
        this.nbt = buffer.method_10798();
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CREATE_TASK_AT;
    }

    public void write(class_2540 buffer) {
        buffer.writeLong(this.chapterId);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.method_10804(this.type.internalId);
        buffer.method_10794(this.nbt);
    }

    public void handle(NetworkManager.PacketContext context) {
        class_1657 class_16572;
        if (NetUtils.canEdit(context) && (class_16572 = context.getPlayer()) instanceof class_3222) {
            class_3222 sp = (class_3222)class_16572;
            ServerQuestFile file = ServerQuestFile.INSTANCE;
            Chapter ch = file.getChapter(this.chapterId);
            if (ch != null) {
                Quest quest = new Quest(file.newID(), ch);
                quest.setX(this.x);
                quest.setY(this.y);
                quest.onCreated();
                new CreateObjectResponseMessage(quest, null).sendToAll(sp.method_5682());
                Task task = this.type.createTask(file.newID(), quest);
                task.readData(this.nbt);
                task.onCreated();
                class_2487 extra = new class_2487();
                extra.method_10582("type", this.type.getTypeForNBT());
                new CreateObjectResponseMessage(task, extra, sp.method_5667()).sendToAll(sp.method_5682());
                file.refreshIDMap();
                file.clearCachedData();
                file.markDirty();
            }
        }
    }
}

