/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.gui.CustomToast;
import dev.ftb.mods.ftbquests.client.gui.RewardTablesScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.OtherButtonsPanel;
import dev.ftb.mods.ftbquests.client.gui.quests.TabButton;
import dev.ftb.mods.ftbquests.net.ChangeProgressMessage;
import dev.ftb.mods.ftbquests.net.ForceSaveMessage;
import dev.ftb.mods.ftbquests.net.ToggleEditingModeMessage;
import dev.ftb.mods.ftbquests.quest.task.StructureTask;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class OtherButtonsPanelBottom
extends OtherButtonsPanel {
    public OtherButtonsPanelBottom(Panel panel) {
        super(panel);
    }

    public void addWidgets() {
        if (this.questScreen.file.canEdit()) {
            this.add((Widget)new EditSettingsButton(this));
        }
        if (FTBQuestsClient.getClientPlayer().method_5687(2) || ClientQuestFile.INSTANCE.hasEditorPermission()) {
            this.add((Widget)new ToggleEditModeButton(this));
        }
        this.add((Widget)new EditPlayerPrefsButton(this));
    }

    public void alignWidgets() {
        this.setHeight(this.align(WidgetLayout.VERTICAL));
        this.setPos(this.questScreen.width - this.width, this.questScreen.height - this.height - 1);
    }

    public static class EditSettingsButton
    extends TabButton {
        public EditSettingsButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"gui.settings"), (Icon)ThemeProperties.SETTINGS_ICON.get());
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (this.questScreen.getContextMenu().isPresent()) {
                this.questScreen.closeContextMenu();
                return;
            }
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.edit_file"), (Icon)ThemeProperties.SETTINGS_ICON.get(), b -> this.questScreen.file.onEditButtonClicked((Runnable)((Object)this))));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.reset_progress"), (Icon)ThemeProperties.RELOAD_ICON.get(), b -> ChangeProgressMessage.sendToServer(this.questScreen.file.selfTeamData, this.questScreen.file, progressChange -> progressChange.setReset(true))).setYesNoText((class_2561)class_2561.method_43471((String)"ftbquests.gui.reset_progress_q")));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.complete_instantly"), (Icon)ThemeProperties.CHECK_ICON.get(), b -> ChangeProgressMessage.sendToServer(this.questScreen.file.selfTeamData, this.questScreen.file, progressChange -> progressChange.setReset(false))).setYesNoText((class_2561)class_2561.method_43471((String)"ftbquests.gui.complete_instantly_q")));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.reward_tables"), (Icon)ThemeProperties.REWARD_TABLE_ICON.get(), b -> new RewardTablesScreen(this.questScreen).openGui()));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.save_on_server"), (Icon)ThemeProperties.SAVE_ICON.get(), b -> new ForceSaveMessage().sendToServer()));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.save_as_file"), (Icon)ThemeProperties.DOWNLOAD_ICON.get(), b -> this.saveLocally()));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.reload_theme"), (Icon)ThemeProperties.RELOAD_ICON.get(), b -> this.reload_theme()));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.wiki"), Icons.INFO, b -> this.handleClick("https://help.ftb.team/mods")));
            this.questScreen.openContextMenu(contextMenu);
        }

        private void reload_theme() {
            class_310 mc = class_310.method_1551();
            ThemeLoader.loadTheme(mc.method_1478());
            ClientQuestFile.INSTANCE.refreshGui();
            class_310.method_1551().method_1566().method_1999((class_368)new CustomToast((class_2561)class_2561.method_43471((String)"ftbquests.gui.reload_theme"), Icons.ACCEPT, (class_2561)class_2561.method_43471((String)"gui.done")));
        }

        private void saveLocally() {
            try {
                Calendar time = Calendar.getInstance();
                StringBuilder fileName = new StringBuilder("local/ftbquests/saved/");
                this.appendNum(fileName, time.get(1), '-');
                this.appendNum(fileName, time.get(2) + 1, '-');
                this.appendNum(fileName, time.get(5), '-');
                this.appendNum(fileName, time.get(11), '-');
                this.appendNum(fileName, time.get(12), '-');
                this.appendNum(fileName, time.get(13), '\u0000');
                File file = new File(class_310.method_1551().field_1697, fileName.toString()).getCanonicalFile();
                ClientQuestFile.INSTANCE.writeDataFull(file.toPath());
                class_5250 component = class_2561.method_43469((String)"ftbquests.gui.saved_as_file", (Object[])new Object[]{"." + file.getPath().replace(class_310.method_1551().field_1697.getCanonicalFile().getAbsolutePath(), "")});
                component.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11746, file.getAbsolutePath()));
                class_310.method_1551().field_1724.method_43496((class_2561)component);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void appendNum(StringBuilder sb, int num, char c) {
            if (num < 10) {
                sb.append('0');
            }
            sb.append(num);
            if (c != '\u0000') {
                sb.append(c);
            }
        }
    }

    public static class ToggleEditModeButton
    extends TabButton {
        public ToggleEditModeButton(Panel panel) {
            super(panel, ToggleEditModeButton.makeTooltip(), ClientQuestFile.canClientPlayerEdit() ? (Icon)ThemeProperties.EDITOR_ICON_ON.get() : (Icon)ThemeProperties.EDITOR_ICON_OFF.get());
        }

        private static class_2561 makeTooltip() {
            String key = ClientQuestFile.canClientPlayerEdit() ? "commands.ftbquests.editing_mode.enabled" : "commands.ftbquests.editing_mode.disabled";
            return class_2561.method_43469((String)key, (Object[])new Object[]{ClientQuestFile.INSTANCE.selfTeamData.getName()});
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (!this.questScreen.file.selfTeamData.getCanEdit((class_1657)class_310.method_1551().field_1724)) {
                StructureTask.maybeRequestStructureSync();
            }
            new ToggleEditingModeMessage().sendToServer();
        }
    }

    private static class EditPlayerPrefsButton
    extends TabButton {
        public EditPlayerPrefsButton(OtherButtonsPanelBottom panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"ftbquests.gui.preferences"), (Icon)ThemeProperties.PREFS_ICON.get());
        }

        public void onClicked(MouseButton button) {
            FTBQuestsClientConfig.openSettings((class_437)new ScreenWrapper((BaseScreen)this.questScreen));
        }
    }
}

