/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client.gui;

import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ColorSelectorPanel;
import dev.ftb.mods.ftblibrary.ui.NordTheme;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.misc.NordColors;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamMessage;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection;
import dev.ftb.mods.ftbteams.client.gui.AllyScreen;
import dev.ftb.mods.ftbteams.client.gui.CreatePartyButton;
import dev.ftb.mods.ftbteams.client.gui.InviteScreen;
import dev.ftb.mods.ftbteams.client.gui.MemberButton;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import dev.ftb.mods.ftbteams.data.PlayerPermissions;
import dev.ftb.mods.ftbteams.data.TeamPropertyCollectionImpl;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.net.SendMessageMessage;
import dev.ftb.mods.ftbteams.net.UpdatePropertiesRequestMessage;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class MyTeamScreen
extends BaseScreen
implements NordColors {
    private final TeamPropertyCollection properties;
    private final PlayerPermissions permissions;
    private final UUID teamID;
    private Button settingsButton;
    private Button infoButton;
    private Button missingDataButton;
    private Button colorButton;
    private Button inviteButton;
    private Button allyButton;
    private Panel memberPanel;
    private Panel chatPanel;
    private TextBox chatBox;
    private static final List<TeamRank> PARTY_RANKS = List.of(TeamRank.OWNER, TeamRank.OFFICER, TeamRank.MEMBER, TeamRank.ALLY);
    private static final int MIN_MEMBER_PANEL_WIDTH = 80;

    public MyTeamScreen(TeamPropertyCollection properties, PlayerPermissions permissions) {
        this.properties = properties;
        this.permissions = permissions;
        this.teamID = this.getManager().selfTeam().getId();
    }

    public static void refreshIfOpen() {
        ScreenWrapper w;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof ScreenWrapper && (class_4372 = (w = (ScreenWrapper)class_4372).getGui()) instanceof MyTeamScreen) {
            MyTeamScreen mts = (MyTeamScreen)class_4372;
            if (mts.getManager().selfTeam().getId().equals(mts.teamID)) {
                mts.refreshWidgets();
            } else {
                mts.closeGui(false);
            }
        }
    }

    private ClientTeamManager getManager() {
        return FTBTeamsAPI.api().getClientManager();
    }

    public boolean onInit() {
        this.setWidth(this.getScreen().method_4486() * 4 / 5);
        this.setHeight(this.getScreen().method_4502() * 4 / 5);
        return true;
    }

    public Theme getTheme() {
        return NordTheme.THEME;
    }

    public void addWidgets() {
        this.settingsButton = new SettingsButton();
        this.add((Widget)this.settingsButton);
        this.infoButton = new SimpleButton((Panel)this, (class_2561)class_2561.method_43473(), Icons.INFO, (w, mb) -> {}){

            public void addMouseOverText(TooltipList list) {
                MyTeamScreen.this.addTeamInfo(list);
            }

            public void playClickSound() {
            }
        };
        this.add((Widget)this.infoButton);
        if (ClientTeamManagerImpl.getInstance().self() == null) {
            this.missingDataButton = new SimpleButton((Panel)this, (class_2561)class_2561.method_43473(), Icons.CLOSE, (w, mb) -> {}){

                public void addMouseOverText(TooltipList list) {
                    list.add((class_2561)class_2561.method_43471((String)"ftbteams.missing_data").method_27692(class_124.field_1061));
                }

                public void playClickSound() {
                }
            };
            this.add((Widget)this.missingDataButton);
        }
        this.colorButton = new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"gui.color"), this.properties.get(TeamProperties.COLOR).withBorder(POLAR_NIGHT_0, false), (simpleButton, mouseButton) -> {
            ColorConfig config = new ColorConfig();
            config.setValue((Object)this.properties.get(TeamProperties.COLOR));
            ColorSelectorPanel.popupAtMouse((BaseScreen)this.getGui(), (ColorConfig)config, accepted -> {
                if (accepted) {
                    Color4I c = (Color4I)config.getValue();
                    this.properties.set(TeamProperties.COLOR, c);
                    simpleButton.setIcon(c.withBorder(POLAR_NIGHT_0, false));
                    TeamPropertyCollectionImpl properties = new TeamPropertyCollectionImpl();
                    properties.set(TeamProperties.COLOR, c);
                    new UpdatePropertiesRequestMessage(properties).sendToServer();
                }
            });
        }){

            public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                this.icon.draw(graphics, x, y, w, h);
            }
        };
        this.add((Widget)this.colorButton);
        this.inviteButton = new InviteButton((Panel)this);
        this.add((Widget)this.inviteButton);
        this.allyButton = new AllyButton((Panel)this);
        this.add((Widget)this.allyButton);
        this.memberPanel = new MemberPanel();
        this.add((Widget)this.memberPanel);
        this.chatPanel = new ChatPanel();
        this.add((Widget)this.chatPanel);
        this.chatBox = new ChatBox();
        this.add((Widget)this.chatBox);
    }

    public void alignWidgets() {
        super.alignWidgets();
        this.colorButton.setPosAndSize(5, 5, 12, 12);
        this.infoButton.setPosAndSize(20, 3, 16, 16);
        if (this.missingDataButton != null) {
            this.missingDataButton.setPosAndSize(40, 3, 16, 16);
        }
        this.settingsButton.setPosAndSize(this.width - 19, 3, 16, 16);
        this.inviteButton.setPosAndSize(this.width - 37, 3, 16, 16);
        this.allyButton.setPosAndSize(this.width - 55, 3, 16, 16);
        this.memberPanel.setPosAndSize(1, 22, Math.max(this.memberPanel.width, 80), this.height - 23);
    }

    private void addTeamInfo(TooltipList list) {
        ClientTeamManager manager = this.getManager();
        if (manager != null) {
            Team team = this.getManager().selfTeam();
            list.add((class_2561)class_2561.method_43471((String)team.getTypeTranslationKey()).method_27692(class_124.field_1075));
            list.add((class_2561)class_2561.method_43469((String)"ftbteams.info.id", (Object[])new Object[]{class_2561.method_43470((String)team.getId().toString()).method_27692(class_124.field_1054)}));
            list.add((class_2561)class_2561.method_43469((String)"ftbteams.info.short_id", (Object[])new Object[]{class_2561.method_43470((String)team.getShortName()).method_27692(class_124.field_1054)}));
            if (!team.getOwner().equals(class_156.field_25140)) {
                list.add((class_2561)class_2561.method_43469((String)"ftbteams.info.owner", (Object[])new Object[]{this.getManager().formatName(team.getOwner())}));
            }
        }
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(graphics, theme, x, y, w, h);
        POLAR_NIGHT_0.draw(graphics, x, y + 21, w, 1);
        POLAR_NIGHT_0.draw(graphics, x + this.memberPanel.width + 1, y + this.memberPanel.posY, 1, this.memberPanel.height + 1);
    }

    public void drawForeground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        super.drawForeground(graphics, theme, x, y, w, h);
        theme.drawString(graphics, (Object)this.properties.get(TeamProperties.DISPLAY_NAME), x + w / 2, y + 7, SNOW_STORM_1, 4);
    }

    public boolean keyPressed(Key key) {
        if (key.is(258)) {
            this.chatBox.setFocused(true);
            return true;
        }
        return super.keyPressed(key);
    }

    public void refreshChat() {
        this.chatPanel.refreshWidgets();
    }

    private class SettingsButton
    extends SimpleButton {
        public SettingsButton() {
            super((Panel)MyTeamScreen.this, (class_2561)class_2561.method_43471((String)"gui.settings"), Icons.SETTINGS.withTint(NordColors.SNOW_STORM_2), (simpleButton, mouseButton) -> {
                ConfigGroup config = new ConfigGroup("ftbteamsconfig", accepted -> {
                    if (accepted) {
                        new UpdatePropertiesRequestMessage(dev$ftb$mods$ftbteams$client$gui$MyTeamScreen$this.properties).sendToServer();
                    }
                    MyTeamScreen.this.openGui();
                });
                HashMap subGroups = new HashMap();
                dev$ftb$mods$ftbteams$client$gui$MyTeamScreen$this.properties.forEach((key, value) -> {
                    String groupName = key.getId().method_12836();
                    ConfigGroup cfg = subGroups.computeIfAbsent(groupName, k -> config.getOrCreateSubgroup(groupName));
                    key.config(cfg, value);
                });
                new EditConfigScreen(config).openGui();
            });
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            this.drawIcon(graphics, theme, x, y, w, h);
        }
    }

    private class InviteButton
    extends SimpleButton {
        public InviteButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"ftbteams.gui.invite"), Icons.ADD, (w, mb) -> new InviteScreen().openGui());
        }

        public boolean isEnabled() {
            if (ClientTeamManagerImpl.getInstance().selfTeam().getType() != TeamType.PARTY || !MyTeamScreen.this.permissions.canInvitePlayer()) {
                return false;
            }
            KnownClientPlayer knownPlayer = ClientTeamManagerImpl.getInstance().self();
            return knownPlayer != null && ClientTeamManagerImpl.getInstance().selfTeam().isOfficerOrBetter(knownPlayer.id());
        }

        public boolean shouldDraw() {
            return this.isEnabled();
        }
    }

    private class AllyButton
    extends SimpleButton {
        public AllyButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"ftbteams.gui.manage_allies"), Icons.FRIENDS, (w, mb) -> new AllyScreen().openGui());
        }

        public boolean isEnabled() {
            if (ClientTeamManagerImpl.getInstance().selfTeam().getType() != TeamType.PARTY || !MyTeamScreen.this.permissions.canAddAlly()) {
                return false;
            }
            KnownClientPlayer knownPlayer = ClientTeamManagerImpl.getInstance().self();
            return knownPlayer != null && ClientTeamManagerImpl.getInstance().selfTeam().isOfficerOrBetter(knownPlayer.id());
        }

        public boolean shouldDraw() {
            return this.isEnabled();
        }
    }

    private class MemberPanel
    extends Panel {
        public MemberPanel() {
            super((Panel)MyTeamScreen.this);
        }

        public void addWidgets() {
            ClientTeamManager manager = MyTeamScreen.this.getManager();
            if (manager == null || !manager.isValid()) {
                return;
            }
            EnumMap byRank = new EnumMap(TeamRank.class);
            manager.selfTeam().getPlayersByRank(TeamRank.NONE).forEach((id, rank) -> manager.getKnownPlayer((UUID)id).ifPresent(kcp -> byRank.computeIfAbsent((TeamRank)((Object)rank), k -> new ArrayList()).add(kcp)));
            for (TeamRank rank2 : PARTY_RANKS) {
                byRank.getOrDefault((Object)rank2, List.of()).stream().sorted(Comparator.comparing(KnownClientPlayer::name)).map(kcp -> new MemberButton(this, (KnownClientPlayer)kcp)).forEach(arg_0 -> ((MemberPanel)this).add(arg_0));
            }
            if (manager.selfTeam().isPlayerTeam()) {
                this.add((Widget)new CreatePartyButton(this, MyTeamScreen.this.permissions.canCreateParty()));
            }
        }

        public void alignWidgets() {
            this.align((WidgetLayout)new WidgetLayout.Vertical(1, 2, 1));
            this.width = 80;
            for (Widget widget : this.widgets) {
                this.width = Math.max(this.width, widget.width);
            }
            for (Widget widget : this.widgets) {
                widget.setX(1);
                widget.setWidth(this.width - 2);
            }
            MyTeamScreen.this.chatPanel.setPosAndSize(this.width + 3, 23, MyTeamScreen.this.width - MyTeamScreen.this.memberPanel.width - 5, MyTeamScreen.this.height - 40);
            MyTeamScreen.this.chatBox.setPosAndSize(MyTeamScreen.this.chatPanel.posX, MyTeamScreen.this.height - 15, MyTeamScreen.this.chatPanel.width, 13);
        }
    }

    private class ChatPanel
    extends Panel {
        public ChatPanel() {
            super((Panel)MyTeamScreen.this);
        }

        public void addWidgets() {
            UUID prev = null;
            ClientTeamManager manager = MyTeamScreen.this.getManager();
            if (manager == null) {
                return;
            }
            for (final TeamMessage message : manager.selfTeam().getMessageHistory()) {
                if (!message.sender().equals(prev)) {
                    this.add((Widget)new VerticalSpaceWidget((Panel)this, 2));
                    class_5250 name = manager.formatName(message.sender()).method_27661().method_27693(":");
                    this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width).setText((class_2561)name));
                    prev = message.sender();
                }
                this.add((Widget)new TextField(this){

                    public void addMouseOverText(TooltipList list) {
                        list.add((class_2561)class_2561.method_43470((String)DateFormat.getInstance().format(new Date(message.date()))));
                    }
                }.setMaxWidth(this.width).setText((class_2561)class_2561.method_43470((String)"  ").method_10852(message.text())));
            }
            if (!this.widgets.isEmpty()) {
                this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width).setText((class_2561)class_2561.method_43473()));
            }
        }

        public void alignWidgets() {
            this.align((WidgetLayout)new WidgetLayout.Vertical(2, 1, 1));
            this.movePanelScroll(0.0, this.getContentHeight());
        }

        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            NordColors.POLAR_NIGHT_2.draw(graphics, x, y, w, h);
        }
    }

    private class ChatBox
    extends TextBox {
        public ChatBox() {
            super((Panel)MyTeamScreen.this);
        }

        public void drawTextBox(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            NordColors.POLAR_NIGHT_3.draw(graphics, x, y, w, h);
        }

        public void onEnterPressed() {
            new SendMessageMessage(this.getText()).sendToServer();
            this.setText("");
            this.setFocused(true);
        }
    }
}

