/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import reborncore.api.items.ArmorBlockEntityTicker;
import reborncore.api.items.ArmorRemoveHandler;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ItemUtils;
import techreborn.config.TechRebornConfig;
import techreborn.items.armor.AttributeModifierBuilder;
import techreborn.items.armor.TRArmourItem;
import techreborn.items.armor.TREnergyArmourItem;

public class QuantumSuitItem
extends TREnergyArmourItem
implements ArmorBlockEntityTicker,
ArmorRemoveHandler {
    private static final Multimap<class_1320, class_1322> FULL_SUIT = new AttributeModifierBuilder().armor(10).toughness(8).knockback(6.0).build();
    private final Multimap<class_1320, class_1322> noPowerAttributes;
    private final Multimap<class_1320, class_1322> hasPowerAttributes;
    private final Multimap<class_1320, class_1322> fullSuitAttributes;
    private final Multimap<class_1320, class_1322> hasPowerSprintAttributes;
    private final Multimap<class_1320, class_1322> fullSuitSprintAttributes;

    public QuantumSuitItem(class_1741 material, class_1738.class_8051 slot) {
        super(material, slot, TechRebornConfig.quantumSuitCapacity, RcEnergyTier.INSANE);
        switch (slot) {
            case field_41934: 
            case field_41937: {
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(3).toughness(2).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(3).toughness(3).knockback(1.0).build();
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(5).toughness(5).knockback(2.0).build();
                this.fullSuitSprintAttributes = null;
                this.hasPowerSprintAttributes = null;
                break;
            }
            case field_41935: {
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(6).toughness(2).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(6).toughness(3).knockback(1.0).build();
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(10).toughness(5).knockback(3.0).build();
                this.fullSuitSprintAttributes = null;
                this.hasPowerSprintAttributes = null;
                break;
            }
            case field_41936: {
                class_1322 modifier = new class_1322(TRArmourItem.MODIFIERS[1], "Movement Speed", 0.15, class_1322.class_1323.field_6328);
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(8).toughness(2).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(8).toughness(3).knockback(1.0).build();
                this.hasPowerSprintAttributes = ImmutableListMultimap.builder().putAll(this.hasPowerAttributes).put((Object)class_5134.field_23719, (Object)modifier).build();
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(10).toughness(5).knockback(3.0).build();
                this.fullSuitSprintAttributes = ImmutableListMultimap.builder().putAll(this.fullSuitAttributes).put((Object)class_5134.field_23719, (Object)modifier).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid slot type");
            }
        }
    }

    public long getEnergyMaxOutput() {
        return 0L;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return HashMultimap.create();
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 equipmentSlot) {
        if (equipmentSlot != this.method_7685()) {
            return ImmutableMultimap.of();
        }
        long energy = this.getStoredEnergy(stack);
        if (energy > 0L) {
            class_2487 nbt = stack.method_7948();
            if (equipmentSlot == class_1304.field_6172 && TechRebornConfig.quantumSuitEnableSprint && nbt.method_10577("isActive") && energy >= TechRebornConfig.quantumSuitSprintingCost) {
                if (nbt.method_10545("HideFlags")) {
                    return this.fullSuitSprintAttributes;
                }
                return this.hasPowerSprintAttributes;
            }
            if (nbt.method_10545("HideFlags")) {
                return this.fullSuitAttributes;
            }
            return this.hasPowerAttributes;
        }
        return this.noPowerAttributes;
    }

    public void tickArmor(class_1799 stack, boolean hasFullSuit, class_1657 playerEntity) {
        class_2487 nbt = stack.method_7948();
        switch (this.method_7685()) {
            case field_6169: {
                if (playerEntity.method_5869() && this.tryUseEnergy(stack, TechRebornConfig.quantumSuitBreathingCost)) {
                    playerEntity.method_6092(new class_1293(class_1294.field_5923, 5, 1));
                }
                if (nbt.method_10577("isActive") && this.tryUseEnergy(stack, TechRebornConfig.suitNightVisionCost)) {
                    playerEntity.method_6092(new class_1293(class_1294.field_5925, 220, 1, false, false));
                    break;
                }
                playerEntity.method_6016(class_1294.field_5925);
                break;
            }
            case field_6174: {
                if (TechRebornConfig.quantumSuitEnableFlight) {
                    if (this.getStoredEnergy(stack) > TechRebornConfig.quantumSuitFlyingCost) {
                        playerEntity.method_31549().field_7478 = true;
                        playerEntity.method_7355();
                        if (playerEntity.method_31549().field_7479) {
                            this.tryUseEnergy(stack, TechRebornConfig.quantumSuitFlyingCost);
                        }
                        playerEntity.method_24830(true);
                    } else {
                        playerEntity.method_31549().field_7478 = false;
                        playerEntity.method_31549().field_7479 = false;
                        playerEntity.method_7355();
                    }
                }
                if (!playerEntity.method_5809() || !this.tryUseEnergy(stack, TechRebornConfig.fireExtinguishCost)) break;
                playerEntity.method_5646();
                break;
            }
            case field_6172: {
                if (!playerEntity.method_5624() || !nbt.method_10577("isActive") || !TechRebornConfig.quantumSuitEnableSprint) break;
                this.tryUseEnergy(stack, TechRebornConfig.quantumSuitSprintingCost);
                break;
            }
            case field_6166: {
                if (!playerEntity.method_5681() || !this.tryUseEnergy(stack, TechRebornConfig.quantumSuitSwimmingCost)) break;
                playerEntity.method_6092(new class_1293(class_1294.field_5900, 5, 1, true, false));
            }
        }
        if (nbt.method_10545("HideFlags")) {
            if (!hasFullSuit) {
                nbt.method_10551("HideFlags");
            }
        } else if (hasFullSuit) {
            nbt.method_10569("HideFlags", class_1799.class_5422.field_25769.method_30269());
        }
    }

    public void onRemoved(class_1657 playerEntity) {
        class_1799 stack;
        if (this.method_7685() == class_1304.field_6174 && TechRebornConfig.quantumSuitEnableFlight) {
            if (!playerEntity.method_7337() && !playerEntity.method_7325()) {
                playerEntity.method_31549().field_7478 = false;
                playerEntity.method_31549().field_7479 = false;
                playerEntity.method_7355();
            }
        } else if (this.method_7685() == class_1304.field_6169) {
            playerEntity.method_6016(class_1294.field_5925);
        }
        if ((stack = playerEntity.field_7498.method_34255()).method_7909() instanceof QuantumSuitItem) {
            class_2487 nbt = stack.method_7948();
            nbt.method_10551("HideFlags");
            nbt.method_10551("isTicking");
        } else {
            playerEntity.method_31548().field_7547.forEach(itemStack -> {
                if (itemStack.method_7909() instanceof QuantumSuitItem) {
                    class_2487 nbt = itemStack.method_7948();
                    nbt.method_10551("HideFlags");
                    nbt.method_10551("isTicking");
                }
            });
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (this.method_7685() == class_1304.field_6169) {
            ItemUtils.buildActiveTooltip((class_1799)stack, tooltip);
        }
        if (this.method_7685() == class_1304.field_6172 && TechRebornConfig.quantumSuitEnableSprint) {
            ItemUtils.buildActiveTooltip((class_1799)stack, tooltip);
        }
    }

    public void appendArmorTooltip(class_1799 stack, List<class_2561> tooltip, boolean shift) {
        ArrayList<class_2561> buffer = new ArrayList<class_2561>();
        class_2487 nbt = stack.method_7948();
        if (this.getStoredEnergy(stack) > 0L) {
            if (nbt.method_10545("HideFlags")) {
                buffer.add((class_2561)class_2561.method_43473());
                buffer.add((class_2561)AttributeModifierBuilder.text(this.method_7685()).method_27692(class_124.field_1080));
                if (shift) {
                    AttributeModifierBuilder.appendText(buffer, this.fullSuitAttributes, class_124.field_1078);
                } else {
                    AttributeModifierBuilder.appendText(buffer, this.method_7685() == class_1304.field_6172 && TechRebornConfig.quantumSuitEnableSprint && nbt.method_10577("isActive") ? this.hasPowerSprintAttributes : this.hasPowerAttributes, class_124.field_1078);
                    buffer.add((class_2561)class_2561.method_43473());
                    buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.full_suit").method_27692(class_124.field_1054));
                    AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1054);
                }
            } else if (shift) {
                buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.all_equipment").method_27692(class_124.field_1080));
                AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1078);
            }
        } else {
            if (!shift && nbt.method_10545("isTicking")) {
                return;
            }
            buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.power").method_27692(class_124.field_1080));
            AttributeModifierBuilder.appendDiffText(buffer, this.noPowerAttributes, this.hasPowerAttributes, class_124.field_1078);
            buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.all_equipment").method_27692(class_124.field_1080));
            AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1078);
        }
        AttributeModifierBuilder.appendEnd(tooltip, buffer);
    }
}

