/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.BuffersJvmKt;
import kotlinx.io.RealSource;
import kotlinx.io.Segment;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io._UtilKt;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a#\u0010\u0006\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\t\u001a\u00020\u0005*\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\n\u001a!\u0010\t\u001a\u00020\u0005*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u000b\u001a\u0011\u0010\r\u001a\u00020\f*\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0019\u0010\u0012\u001a\u00020\u0011*\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0011\u0010\u0015\u001a\u00020\u0014*\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lkotlinx/io/Buffer;", "", "byteCount", "Ljava/nio/charset/Charset;", "charset", "", "readStringImpl", "(Lkotlinx/io/Buffer;JLjava/nio/charset/Charset;)Ljava/lang/String;", "Lkotlinx/io/Source;", "readString", "(Lkotlinx/io/Source;Ljava/nio/charset/Charset;)Ljava/lang/String;", "(Lkotlinx/io/Source;JLjava/nio/charset/Charset;)Ljava/lang/String;", "Ljava/io/InputStream;", "asInputStream", "(Lkotlinx/io/Source;)Ljava/io/InputStream;", "Ljava/nio/ByteBuffer;", "sink", "", "readAtMostTo", "(Lkotlinx/io/Source;Ljava/nio/ByteBuffer;)I", "Ljava/nio/channels/ReadableByteChannel;", "asByteChannel", "(Lkotlinx/io/Source;)Ljava/nio/channels/ReadableByteChannel;", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nSourcesJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourcesJvm.kt\nkotlinx/io/SourcesJvmKt\n+ 2 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n99#2:178\n100#2,8:180\n1#3:179\n*S KotlinDebug\n*F\n+ 1 SourcesJvm.kt\nkotlinx/io/SourcesJvmKt\n*L\n41#1:178\n41#1:180,8\n41#1:179\n*E\n"})
public final class SourcesJvmKt {
    /*
     * WARNING - void declaration
     */
    private static final String readStringImpl(Buffer $this$readStringImpl, long byteCount, Charset charset) {
        int bytesRead$iv;
        int n;
        void pos;
        void limit;
        if (!(byteCount >= 0L && byteCount <= Integer.MAX_VALUE)) {
            boolean $i$a$-require-SourcesJvmKt$readStringImpl$22 = false;
            String $i$a$-require-SourcesJvmKt$readStringImpl$22 = "byteCount (" + byteCount + ") is not within the range [0..2147483647)";
            throw new IllegalArgumentException($i$a$-require-SourcesJvmKt$readStringImpl$22.toString());
        }
        if ($this$readStringImpl.getSize() < byteCount) {
            throw new EOFException("Buffer contains less bytes then required (byteCount: " + byteCount + ", size: " + $this$readStringImpl.getSize() + ')');
        }
        if (byteCount == 0L) {
            return "";
        }
        String result2 = null;
        UnsafeBufferOperations this_$iv = UnsafeBufferOperations.INSTANCE;
        boolean $i$f$readFromHead = false;
        if (!(!$this$readStringImpl.exhausted())) {
            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
            String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
        }
        Segment segment = $this$readStringImpl.getHead();
        Intrinsics.checkNotNull((Object)segment);
        Segment head$iv = segment;
        int n2 = head$iv.getLimit();
        int n3 = head$iv.getPos();
        byte[] data = head$iv.dataAsByteArray(true);
        boolean bl = false;
        void len = limit - pos;
        if ((long)len >= byteCount) {
            result2 = new String(data, (int)pos, (int)byteCount, charset);
            n = (int)byteCount;
        } else {
            n = 0;
        }
        if ((bytesRead$iv = n) != 0) {
            if (bytesRead$iv < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead$iv > head$iv.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            $this$readStringImpl.skip(bytesRead$iv);
        }
        return result2 == null ? new String(SourcesKt.readByteArray($this$readStringImpl, (int)byteCount), charset) : result2;
    }

    @NotNull
    public static final String readString(@NotNull Source $this$readString, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        long req = 1L;
        while ($this$readString.request(req)) {
            req *= (long)2;
        }
        return SourcesJvmKt.readStringImpl($this$readString.getBuffer(), $this$readString.getBuffer().getSize(), charset);
    }

    @NotNull
    public static final String readString(@NotNull Source $this$readString, long byteCount, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        $this$readString.require(byteCount);
        return SourcesJvmKt.readStringImpl($this$readString.getBuffer(), byteCount, charset);
    }

    @NotNull
    public static final InputStream asInputStream(@NotNull Source $this$asInputStream) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)$this$asInputStream, (String)"<this>");
        Source source = $this$asInputStream;
        if (source instanceof RealSource) {
            function0 = (Function0)new MutablePropertyReference0Impl($this$asInputStream){

                public Object get() {
                    return ((RealSource)this.receiver).closed;
                }

                public void set(Object value) {
                    ((RealSource)this.receiver).closed = (Boolean)value;
                }
            };
        } else if (source instanceof Buffer) {
            function0 = SourcesJvmKt::asInputStream$lambda$2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function0 isClosed2 = function0;
        return new InputStream((Function0<Boolean>)isClosed2, $this$asInputStream){
            final /* synthetic */ Function0<Boolean> $isClosed;
            final /* synthetic */ Source $this_asInputStream;
            {
                this.$isClosed = $isClosed;
                this.$this_asInputStream = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public int read() {
                void $this$and$iv;
                if (((Boolean)this.$isClosed.invoke()).booleanValue()) {
                    throw new IOException("Underlying source is closed.");
                }
                if (this.$this_asInputStream.exhausted()) {
                    return -1;
                }
                byte by = this.$this_asInputStream.readByte();
                int other$iv = 255;
                boolean $i$f$and = false;
                return $this$and$iv & other$iv;
            }

            public int read(byte[] data, int offset, int byteCount) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (((Boolean)this.$isClosed.invoke()).booleanValue()) {
                    throw new IOException("Underlying source is closed.");
                }
                _UtilKt.checkOffsetAndCount(data.length, offset, byteCount);
                return this.$this_asInputStream.readAtMostTo(data, offset, offset + byteCount);
            }

            /*
             * WARNING - void declaration
             */
            public int available() {
                void a$iv;
                if (((Boolean)this.$isClosed.invoke()).booleanValue()) {
                    throw new IOException("Underlying source is closed.");
                }
                long l = this.$this_asInputStream.getBuffer().getSize();
                int b$iv = Integer.MAX_VALUE;
                boolean $i$f$minOf = false;
                return (int)Math.min((long)a$iv, (long)b$iv);
            }

            public void close() {
                this.$this_asInputStream.close();
            }

            public String toString() {
                return this.$this_asInputStream + ".asInputStream()";
            }
        };
    }

    public static final int readAtMostTo(@NotNull Source $this$readAtMostTo, @NotNull ByteBuffer sink) {
        Intrinsics.checkNotNullParameter((Object)$this$readAtMostTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if ($this$readAtMostTo.getBuffer().getSize() == 0L) {
            $this$readAtMostTo.request(8192L);
            if ($this$readAtMostTo.getBuffer().getSize() == 0L) {
                return -1;
            }
        }
        return BuffersJvmKt.readAtMostTo($this$readAtMostTo.getBuffer(), sink);
    }

    @NotNull
    public static final ReadableByteChannel asByteChannel(@NotNull Source $this$asByteChannel) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)$this$asByteChannel, (String)"<this>");
        Source source = $this$asByteChannel;
        if (source instanceof RealSource) {
            function0 = (Function0)new MutablePropertyReference0Impl($this$asByteChannel){

                public Object get() {
                    return ((RealSource)this.receiver).closed;
                }

                public void set(Object value) {
                    ((RealSource)this.receiver).closed = (Boolean)value;
                }
            };
        } else if (source instanceof Buffer) {
            function0 = SourcesJvmKt::asByteChannel$lambda$3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function0 isClosed2 = function0;
        return new ReadableByteChannel($this$asByteChannel, (Function0<Boolean>)isClosed2){
            final /* synthetic */ Source $this_asByteChannel;
            final /* synthetic */ Function0<Boolean> $isClosed;
            {
                this.$this_asByteChannel = $receiver;
                this.$isClosed = $isClosed;
            }

            public void close() {
                this.$this_asByteChannel.close();
            }

            public boolean isOpen() {
                return (Boolean)this.$isClosed.invoke() == false;
            }

            public int read(ByteBuffer sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                return SourcesJvmKt.readAtMostTo(this.$this_asByteChannel, sink);
            }
        };
    }

    private static final boolean asInputStream$lambda$2() {
        return false;
    }

    private static final boolean asByteChannel$lambda$3() {
        return false;
    }
}

