/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.css;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.css.CssValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0018\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lkotlinx/css/LinearDimension;", "Lkotlinx/css/CssValue;", "", "value", "<init>", "(Ljava/lang/String;)V", "", "times", "div", "(Ljava/lang/Number;)Lkotlinx/css/LinearDimension;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "minus", "(Lkotlinx/css/LinearDimension;)Lkotlinx/css/LinearDimension;", "plus", "unaryMinus", "()Lkotlinx/css/LinearDimension;", "Ljava/lang/String;", "getValue", "()Ljava/lang/String;", "getValueCalcSafe", "valueCalcSafe", "Companion", "kotlin-css"})
public class LinearDimension
extends CssValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private static final LinearDimension none = new LinearDimension("none");
    @NotNull
    private static final LinearDimension auto = new LinearDimension("auto");
    @NotNull
    private static final LinearDimension initial = new LinearDimension("initial");
    @NotNull
    private static final LinearDimension inherit = new LinearDimension("inherit");
    @NotNull
    private static final LinearDimension available = new LinearDimension("available");
    @NotNull
    private static final LinearDimension fillAvailable = new LinearDimension("fill-available");
    @NotNull
    private static final LinearDimension borderBox = new LinearDimension("border-box");
    @NotNull
    private static final LinearDimension contentBox = new LinearDimension("content-box");
    @NotNull
    private static final LinearDimension maxContent = new LinearDimension("max-content");
    @NotNull
    private static final LinearDimension minContent = new LinearDimension("min-content");
    @NotNull
    private static final LinearDimension fitContent = new LinearDimension("fit-content");

    public LinearDimension(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(value);
        this.value = value;
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    private final String getValueCalcSafe() {
        return Intrinsics.areEqual((Object)this.getValue(), (Object)"0") ? "0px" : this.getValue();
    }

    @NotNull
    public final LinearDimension unaryMinus() {
        Object object;
        if (StringsKt.startsWith$default((CharSequence)this.getValue(), (char)'-', (boolean)false, (int)2, null)) {
            String string = this.getValue().substring(1);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            object = StringsKt.startsWith$default((String)this.getValue(), (String)"calc", (boolean)false, (int)2, null) ? "calc(0px - " + this.getValue() + ")" : (Intrinsics.areEqual((Object)this.getValue(), (Object)"0") ? this.getValue() : "-" + this.getValue());
        }
        return new LinearDimension((String)object);
    }

    @NotNull
    public final LinearDimension plus(@NotNull LinearDimension other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new LinearDimension("calc(" + this.getValueCalcSafe() + " + " + other.getValueCalcSafe() + ")");
    }

    @NotNull
    public final LinearDimension minus(@NotNull LinearDimension other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new LinearDimension("calc(" + this.getValueCalcSafe() + " - " + other.getValueCalcSafe() + ")");
    }

    @NotNull
    public final LinearDimension times(@NotNull Number times) {
        Intrinsics.checkNotNullParameter((Object)times, (String)"times");
        return new LinearDimension("calc(" + this.getValueCalcSafe() + " * " + times + ")");
    }

    @NotNull
    public final LinearDimension div(@NotNull Number times) {
        Intrinsics.checkNotNullParameter((Object)times, (String)"times");
        return new LinearDimension("calc(" + this.getValueCalcSafe() + " / " + times + ")");
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LinearDimension cfr_ignored_0 = (LinearDimension)other;
        return Intrinsics.areEqual((Object)this.getValue(), (Object)((LinearDimension)other).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u0006\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0006\u001a\u0004\b\u0010\u0010\bR\u0017\u0010\u0011\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0006\u001a\u0004\b\u0012\u0010\bR\u0017\u0010\u0013\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0006\u001a\u0004\b\u0014\u0010\bR\u0017\u0010\u0015\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0006\u001a\u0004\b\u0016\u0010\bR\u0017\u0010\u0017\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0006\u001a\u0004\b\u0018\u0010\bR\u0017\u0010\u0019\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0006\u001a\u0004\b\u001a\u0010\bR\u0017\u0010\u001b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0006\u001a\u0004\b\u001c\u0010\b\u00a8\u0006\u001d"}, d2={"Lkotlinx/css/LinearDimension$Companion;", "", "<init>", "()V", "Lkotlinx/css/LinearDimension;", "auto", "Lkotlinx/css/LinearDimension;", "getAuto", "()Lkotlinx/css/LinearDimension;", "available", "getAvailable", "borderBox", "getBorderBox", "contentBox", "getContentBox", "fillAvailable", "getFillAvailable", "fitContent", "getFitContent", "inherit", "getInherit", "initial", "getInitial", "maxContent", "getMaxContent", "minContent", "getMinContent", "none", "getNone", "kotlin-css"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LinearDimension getNone() {
            return none;
        }

        @NotNull
        public final LinearDimension getAuto() {
            return auto;
        }

        @NotNull
        public final LinearDimension getInitial() {
            return initial;
        }

        @NotNull
        public final LinearDimension getInherit() {
            return inherit;
        }

        @NotNull
        public final LinearDimension getAvailable() {
            return available;
        }

        @NotNull
        public final LinearDimension getFillAvailable() {
            return fillAvailable;
        }

        @NotNull
        public final LinearDimension getBorderBox() {
            return borderBox;
        }

        @NotNull
        public final LinearDimension getContentBox() {
            return contentBox;
        }

        @NotNull
        public final LinearDimension getMaxContent() {
            return maxContent;
        }

        @NotNull
        public final LinearDimension getMinContent() {
            return minContent;
        }

        @NotNull
        public final LinearDimension getFitContent() {
            return fitContent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

