/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.crops.CropLikeRegistry;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.Shape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import dev.ftb.mods.ftbultimine.utils.PlatformMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class FTBUltiminePlayerData {
    private final UUID playerId;
    private boolean pressed = false;
    private int shapeIndex = 0;
    private double pendingXPCost;
    private class_2338 cachedPos;
    private class_2350 cachedDirection;
    private List<class_2338> cachedBlocks;

    public FTBUltiminePlayerData(UUID playerId) {
        this.playerId = playerId;
    }

    public void clearCache() {
        this.cachedPos = null;
        this.cachedDirection = null;
        this.cachedBlocks = null;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public boolean hasCachedPositions() {
        return this.cachedBlocks != null && !this.cachedBlocks.isEmpty();
    }

    public Collection<class_2338> cachedPositions() {
        return this.cachedBlocks;
    }

    public static class_239 rayTrace(class_3222 player) {
        double distance = PlatformMethods.reach(player);
        return player.method_5745(player.method_7337() ? distance + 0.5 : distance, 1.0f, false);
    }

    public Shape getCurrentShape() {
        return ShapeRegistry.getShape(this.shapeIndex);
    }

    public int getCurrentShapeIndex() {
        return this.shapeIndex;
    }

    public void cycleShape(boolean next) {
        if (next) {
            if (++this.shapeIndex >= ShapeRegistry.shapeCount()) {
                this.shapeIndex = 0;
            }
        } else if (--this.shapeIndex < 0) {
            this.shapeIndex = ShapeRegistry.shapeCount() - 1;
        }
    }

    public void addPendingXPCost(int blockCount) {
        this.pendingXPCost += (double)blockCount * (Double)FTBUltimineServerConfig.EXPERIENCE_PER_BLOCK.get();
    }

    public void takePendingXP(class_3222 player) {
        if (this.pendingXPCost > 1.0) {
            int toTake = (int)this.pendingXPCost;
            String cmd = String.format("experience add @s -%d points", toTake);
            class_2168 source = player.method_5671().method_9217();
            player.method_5682().method_3734().method_44252(source, cmd);
            this.pendingXPCost -= (double)toTake;
        }
    }

    public void checkBlocks(class_3222 player, boolean sendUpdate, int maxBlocks) {
        class_3965 hitResult;
        block8: {
            block7: {
                if (!this.pressed) {
                    return;
                }
                class_239 result = FTBUltiminePlayerData.rayTrace(player);
                if (!(result instanceof class_3965)) break block7;
                hitResult = (class_3965)result;
                if (result.method_17783() == class_239.class_240.field_1332) break block8;
            }
            if (this.cachedBlocks != null && !this.cachedBlocks.isEmpty()) {
                this.clearCache();
                if (sendUpdate) {
                    new SendShapePacket(this.getCurrentShapeIndex(), Collections.emptyList()).sendTo(player);
                }
            }
            return;
        }
        if (this.cachedDirection != hitResult.method_17780() || this.cachedPos == null || !this.cachedPos.equals((Object)hitResult.method_17777())) {
            this.updateBlocks(player, hitResult.method_17777(), hitResult.method_17780(), sendUpdate, maxBlocks);
        }
    }

    @Nullable
    public ShapeContext updateBlocks(class_3222 player, class_2338 pos, class_2350 dir, boolean sendUpdate, int maxBlocks) {
        ShapeContext context = null;
        this.cachedPos = pos.method_10062();
        this.cachedDirection = dir;
        Shape shape = this.getCurrentShape();
        if (maxBlocks <= 0) {
            this.cachedBlocks = Collections.emptyList();
        } else {
            int max;
            class_2680 origState = player.method_37908().method_8320(this.cachedPos);
            BlockMatcher matcher = shape.getTagMatcher().actualCheck(origState, origState) ? shape.getTagMatcher() : (CropLikeRegistry.getInstance().getHandlerFor(player.method_37908(), this.cachedPos, origState).isPresent() ? BlockMatcher.CROP_LIKE : BlockMatcher.MATCH);
            context = new ShapeContext(player, this.cachedPos, this.cachedDirection, player.method_37908().method_8320(this.cachedPos), matcher, maxBlocks);
            this.cachedBlocks = shape.getBlocks(context);
            if ((Double)FTBUltimineServerConfig.EXPERIENCE_PER_BLOCK.get() > 0.0 && (max = (int)((double)player.field_7495 / (Double)FTBUltimineServerConfig.EXPERIENCE_PER_BLOCK.get())) < this.cachedBlocks.size()) {
                this.cachedBlocks = this.cachedBlocks.subList(0, max);
            }
        }
        if (sendUpdate) {
            new SendShapePacket(this.getCurrentShapeIndex(), this.cachedBlocks).sendTo(player);
        }
        return context;
    }
}

