/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.DoubleConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditStringConfigOverlay;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.NordTheme;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractThreePanelScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class EditRewardTableScreen
extends AbstractButtonListScreen {
    private final Runnable parentScreen;
    private final RewardTable editedTable;
    private final Consumer<RewardTable> callback;
    boolean changed = false;

    public EditRewardTableScreen(Runnable parentScreen, RewardTable originalTable, Consumer<RewardTable> callback) {
        this.parentScreen = parentScreen;
        this.callback = callback;
        this.editedTable = QuestObjectBase.copy(originalTable, () -> new RewardTable(originalTable.id, originalTable.getFile()));
        this.setBorder(1, 1, 1);
    }

    protected Panel createTopPanel() {
        return new CustomTopPanel();
    }

    protected int getTopPanelHeight() {
        return 25;
    }

    public void addButtons(Panel panel) {
        this.editedTable.getWeightedRewards().forEach(wr -> panel.add((Widget)new WeightedRewardButton(panel, (WeightedReward)wr)));
    }

    public boolean onInit() {
        this.setTitle((class_2561)class_2561.method_43470((String)Objects.requireNonNull(this.editedTable).getRawTitle()));
        return super.onInit();
    }

    public Theme getTheme() {
        return NordTheme.THEME;
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.doCancel();
            return true;
        }
        return false;
    }

    protected void doCancel() {
        if (this.changed) {
            this.openYesNo((class_2561)class_2561.method_43471((String)"ftblibrary.unsaved_changes"), (class_2561)class_2561.method_43473(), this.parentScreen);
        } else {
            this.parentScreen.run();
        }
    }

    protected void doAccept() {
        this.callback.accept(this.editedTable);
        this.parentScreen.run();
    }

    private class CustomTopPanel
    extends AbstractThreePanelScreen.TopPanel {
        private final RewardTableSettingsButton settingsButton;
        private final AddWeightedRewardButton addButton;

        public CustomTopPanel() {
            super((AbstractThreePanelScreen)EditRewardTableScreen.this);
            this.settingsButton = new RewardTableSettingsButton((Panel)this);
            this.addButton = new AddWeightedRewardButton((Panel)this);
        }

        public void addWidgets() {
            this.add((Widget)this.settingsButton);
            this.add((Widget)this.addButton);
        }

        public void alignWidgets() {
            this.settingsButton.setPosAndSize(this.width - 18, 2, 16, 16);
            this.addButton.setPosAndSize(this.width - 36, 2, 16, 16);
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            super.draw(graphics, theme, x, y, w, h);
            EditRewardTableScreen.this.editedTable.getIcon().draw(graphics, x + 2, y + 2, 16, 16);
            theme.drawString(graphics, (Object)this.getGui().getTitle(), x + 20, y + 6, 2);
        }
    }

    private class WeightedRewardButton
    extends SimpleTextButton {
        private final WeightedReward wr;

        private WeightedRewardButton(Panel panel, WeightedReward wr) {
            super(panel, wr.getReward().getTitle(), wr.getReward().getIcon());
            this.wr = wr;
            this.setHeight(16);
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            if (this.getMouseX() > this.getX() + this.width - 13) {
                list.add((class_2561)class_2561.method_43471((String)"gui.remove"));
            } else if (this.getMouseX() > this.getX() + this.width - 26) {
                list.add((class_2561)class_2561.method_43471((String)"ftbquests.reward_table.set_weight"));
            } else {
                this.wr.getReward().addMouseOverText(list);
                String w = String.format("%.2f", Float.valueOf(this.wr.getWeight()));
                String str = WeightedReward.chanceString(this.wr.getWeight(), EditRewardTableScreen.this.editedTable.getTotalWeight(true));
                list.add((class_2561)class_2561.method_43471((String)"ftbquests.reward_table.weight").method_27693(": " + w).method_10852((class_2561)class_2561.method_43470((String)(" [" + str + "]")).method_27692(class_124.field_1063)));
            }
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (button.isLeft()) {
                if (this.getMouseX() > this.getX() + this.width - 13) {
                    EditRewardTableScreen.this.openYesNo((class_2561)class_2561.method_43469((String)"delete_item", (Object[])new Object[]{this.wr.getReward().getTitle()}), (class_2561)class_2561.method_43473(), this::doDeletion);
                } else if (this.getMouseX() > this.getX() + this.width - 26) {
                    this.setEntryWeight();
                } else {
                    this.editRewardTableEntry();
                }
            } else {
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.edit"), ItemIcon.getItemIcon((class_1792)class_1802.field_8153), b -> this.editRewardTableEntry()));
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.reward_table.set_weight"), ItemIcon.getItemIcon((class_1792)class_1802.field_8782), b -> this.setEntryWeight()));
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.remove"), Icons.BIN, b -> this.doDeletion()).setYesNoText((class_2561)class_2561.method_43469((String)"delete_item", (Object[])new Object[]{this.wr.getReward().getTitle()})));
                EditRewardTableScreen.this.openContextMenu(contextMenu);
            }
        }

        private void doDeletion() {
            EditRewardTableScreen.this.editedTable.removeReward(this.wr);
            EditRewardTableScreen.this.refreshWidgets();
            EditRewardTableScreen.this.changed = true;
        }

        private void setEntryWeight() {
            DoubleConfig c = new DoubleConfig(0.0, Double.POSITIVE_INFINITY);
            c.setValue((Object)this.wr.getWeight());
            EditStringConfigOverlay overlay = new EditStringConfigOverlay(this.parent, (ConfigFromString)c, accepted -> {
                if (accepted) {
                    this.wr.setWeight(((Double)c.getValue()).floatValue());
                    EditRewardTableScreen.this.changed = true;
                }
            }).atPosition(this.parent.width - 80, this.getPosY());
            overlay.setExtraZlevel(300);
            this.getGui().pushModalPanel((ModalPanel)overlay);
        }

        private void editRewardTableEntry() {
            ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
                if (accepted) {
                    this.wr.getReward().clearCachedData();
                    EditRewardTableScreen.this.changed = true;
                }
                this.run();
            }){

                public class_2561 getName() {
                    return WeightedRewardButton.this.wr.getReward().getTitle();
                }
            };
            this.wr.getReward().fillConfigGroup(this.wr.getReward().createSubGroup(group));
            new EditConfigScreen(group).openGui();
        }

        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver) {
                Color4I.WHITE.withAlpha(30).draw(graphics, x, y, w, h);
                ItemIcon.getItemIcon((class_1792)class_1802.field_8782).draw(graphics, x + w - 26, y + 2, 12, 12);
                Icons.BIN.draw(graphics, x + w - 13, y + 2, 12, 12);
            }
            Color4I.GRAY.withAlpha(40).draw(graphics, x, y + h, w, 1);
        }

        public Optional<PositionedIngredient> getIngredientUnderMouse() {
            return PositionedIngredient.of(this.wr.getReward().getIngredient((Widget)this), (Widget)this);
        }
    }

    private class AddWeightedRewardButton
    extends SimpleButton {
        private AddWeightedRewardButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"gui.add"), Icons.ADD, (b, mb) -> {});
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            for (RewardType type : RewardTypes.TYPES.values()) {
                if (type.getExcludeFromListRewards()) continue;
                contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIconSupplier(), b -> {
                    this.playClickSound();
                    type.getGuiProvider().openCreationGui(this.parent, EditRewardTableScreen.this.editedTable.getFakeQuest(), reward -> {
                        EditRewardTableScreen.this.editedTable.addReward(new WeightedReward((Reward)reward, 1.0f));
                        EditRewardTableScreen.this.changed = true;
                        this.openGui();
                    });
                }));
            }
            this.getGui().openContextMenu(contextMenu);
        }
    }

    private class RewardTableSettingsButton
    extends SimpleButton {
        private RewardTableSettingsButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"gui.settings"), Icons.SETTINGS, (b, mb) -> {});
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
                EditRewardTableScreen.this.editedTable.clearCachedData();
                this.run();
            }){

                public class_2561 getName() {
                    return EditRewardTableScreen.this.editedTable.getTitle();
                }
            };
            EditRewardTableScreen.this.editedTable.fillConfigGroup(EditRewardTableScreen.this.editedTable.createSubGroup(group));
            new EditConfigScreen(group).openGui();
        }
    }
}

