/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonDecodingException;
import kotlinx.serialization.json.internal.JsonEncodingException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000B\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u001f\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a'\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\u0005\u0010\t\u001a\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001b\u0010\u0013\u001a\u00020\u0012*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u001d\u0010\u0016\u001a\u00020\u0012*\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0017\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0018H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u000e\u0010\u001d\u001a'\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a'\u0010 \u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b \u0010!\u001a\u001d\u0010\"\u001a\u00020\u0007*\u00020\u00072\b\b\u0002\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"", "offset", "", "message", "Lkotlinx/serialization/json/internal/JsonDecodingException;", "JsonDecodingException", "(ILjava/lang/String;)Lkotlinx/serialization/json/internal/JsonDecodingException;", "", "input", "(ILjava/lang/String;Ljava/lang/CharSequence;)Lkotlinx/serialization/json/internal/JsonDecodingException;", "", "value", "output", "Lkotlinx/serialization/json/internal/JsonEncodingException;", "InvalidFloatingPointEncoded", "(Ljava/lang/Number;Ljava/lang/String;)Lkotlinx/serialization/json/internal/JsonEncodingException;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "result", "", "throwInvalidFloatingPointDecoded", "(Lkotlinx/serialization/json/internal/AbstractJsonLexer;Ljava/lang/Number;)Ljava/lang/Void;", "entity", "invalidTrailingComma", "(Lkotlinx/serialization/json/internal/AbstractJsonLexer;Ljava/lang/String;)Ljava/lang/Void;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "keyDescriptor", "InvalidKeyKindException", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/json/internal/JsonEncodingException;", "key", "(Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;)Lkotlinx/serialization/json/internal/JsonEncodingException;", "InvalidFloatingPointDecoded", "(Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;)Lkotlinx/serialization/json/internal/JsonDecodingException;", "unexpectedFpErrorMessage", "(Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "minify", "(Ljava/lang/CharSequence;I)Ljava/lang/CharSequence;", "kotlinx-serialization-json"})
public final class JsonExceptionsKt {
    @NotNull
    public static final JsonDecodingException JsonDecodingException(int offset, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return new JsonDecodingException(offset >= 0 ? "Unexpected JSON token at offset " + offset + ": " + message : message);
    }

    @NotNull
    public static final JsonDecodingException JsonDecodingException(int offset, @NotNull String message, @NotNull CharSequence input) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return JsonExceptionsKt.JsonDecodingException(offset, message + "\nJSON input: " + JsonExceptionsKt.minify(input, offset));
    }

    @NotNull
    public static final JsonEncodingException InvalidFloatingPointEncoded(@NotNull Number value, @NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return new JsonEncodingException("Unexpected special floating-point value " + value + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(output, 0, 1, null));
    }

    @NotNull
    public static final Void throwInvalidFloatingPointDecoded(@NotNull AbstractJsonLexer $this$throwInvalidFloatingPointDecoded, @NotNull Number result2) {
        Intrinsics.checkNotNullParameter((Object)$this$throwInvalidFloatingPointDecoded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        AbstractJsonLexer.fail$default($this$throwInvalidFloatingPointDecoded, "Unexpected special floating-point value " + result2 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification", 0, "It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'", 2, null);
        throw new KotlinNothingValueException();
    }

    @NotNull
    public static final Void invalidTrailingComma(@NotNull AbstractJsonLexer $this$invalidTrailingComma, @NotNull String entity) {
        Intrinsics.checkNotNullParameter((Object)$this$invalidTrailingComma, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        $this$invalidTrailingComma.fail("Trailing comma before the end of JSON " + entity, $this$invalidTrailingComma.currentPosition - 1, "Trailing commas are non-complaint JSON and not allowed by default. Use 'allowTrailingComma = true' in 'Json {}' builder to support them.");
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Void invalidTrailingComma$default(AbstractJsonLexer abstractJsonLexer, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "object";
        }
        return JsonExceptionsKt.invalidTrailingComma(abstractJsonLexer, string);
    }

    @NotNull
    public static final JsonEncodingException InvalidKeyKindException(@NotNull SerialDescriptor keyDescriptor) {
        Intrinsics.checkNotNullParameter((Object)keyDescriptor, (String)"keyDescriptor");
        return new JsonEncodingException("Value of type '" + keyDescriptor.getSerialName() + "' can't be used in JSON as a key in the map. It should have either primitive or enum kind, but its kind is '" + keyDescriptor.getKind() + "'.\nUse 'allowStructuredMapKeys = true' in 'Json {}' builder to convert such maps to [key1, value1, key2, value2,...] arrays.");
    }

    @NotNull
    public static final JsonEncodingException InvalidFloatingPointEncoded(@NotNull Number value, @NotNull String key, @NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return new JsonEncodingException(JsonExceptionsKt.unexpectedFpErrorMessage(value, key, output));
    }

    @NotNull
    public static final JsonDecodingException InvalidFloatingPointDecoded(@NotNull Number value, @NotNull String key, @NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return JsonExceptionsKt.JsonDecodingException(-1, JsonExceptionsKt.unexpectedFpErrorMessage(value, key, output));
    }

    private static final String unexpectedFpErrorMessage(Number value, String key, String output) {
        return "Unexpected special floating-point value " + value + " with key " + key + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(output, 0, 1, null);
    }

    @NotNull
    public static final CharSequence minify(@NotNull CharSequence $this$minify, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$minify, (String)"<this>");
        if ($this$minify.length() < 200) {
            return $this$minify;
        }
        if (offset == -1) {
            int start2 = $this$minify.length() - 60;
            if (start2 <= 0) {
                return $this$minify;
            }
            CharSequence charSequence = $this$minify;
            int n = charSequence.length();
            return "....." + ((Object)charSequence.subSequence(start2, n)).toString();
        }
        int start3 = offset - 30;
        int end = offset + 30;
        String prefix2 = start3 <= 0 ? "" : ".....";
        String suffix = end >= $this$minify.length() ? "" : ".....";
        return prefix2 + ((Object)$this$minify.subSequence(RangesKt.coerceAtLeast((int)start3, (int)0), RangesKt.coerceAtMost((int)end, (int)$this$minify.length()))).toString() + suffix;
    }

    public static /* synthetic */ CharSequence minify$default(CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return JsonExceptionsKt.minify(charSequence, n);
    }
}

