/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.files;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.files.AnimalSnifferIgnore;
import kotlinx.io.files.Mover;
import kotlinx.io.files.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lkotlinx/io/files/NioMover;", "Lkotlinx/io/files/Mover;", "<init>", "()V", "Lkotlinx/io/files/Path;", "source", "destination", "", "move", "(Lkotlinx/io/files/Path;Lkotlinx/io/files/Path;)V", "kotlinx-io-core"})
final class NioMover
implements Mover {
    @Override
    @AnimalSnifferIgnore
    public void move(@NotNull Path source, @NotNull Path destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!source.getFile$kotlinx_io_core().exists()) {
            throw new FileNotFoundException("Source file does not exist: " + source.getFile$kotlinx_io_core());
        }
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Files.move(source.getFile$kotlinx_io_core().toPath(), destination.getFile$kotlinx_io_core().toPath(), copyOptionArray);
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException("Move failed", e);
        }
    }
}

