/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.bytestring;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.ByteStringKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0005R\u0016\u0010\u0015\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lkotlinx/io/bytestring/ByteStringBuilder;", "", "", "initialCapacity", "<init>", "(I)V", "Lkotlinx/io/bytestring/ByteString;", "toByteString", "()Lkotlinx/io/bytestring/ByteString;", "", "byte", "", "append", "(B)V", "", "array", "startIndex", "endIndex", "([BII)V", "requiredCapacity", "ensureCapacity", "buffer", "[B", "offset", "I", "getSize", "()I", "size", "getCapacity", "capacity", "kotlinx-io-bytestring"})
@SourceDebugExtension(value={"SMAP\nByteStringBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteStringBuilder.kt\nkotlinx/io/bytestring/ByteStringBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
public final class ByteStringBuilder {
    @NotNull
    private byte[] buffer;
    private int offset;

    public ByteStringBuilder(int initialCapacity) {
        this.buffer = new byte[initialCapacity];
    }

    public /* synthetic */ ByteStringBuilder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public final int getSize() {
        return this.offset;
    }

    public final int getCapacity() {
        return this.buffer.length;
    }

    @NotNull
    public final ByteString toByteString() {
        if (this.getSize() == 0) {
            return ByteStringKt.ByteString();
        }
        if (this.buffer.length == this.getSize()) {
            return ByteString.Companion.wrap$kotlinx_io_bytestring(this.buffer);
        }
        return new ByteString(this.buffer, 0, this.getSize());
    }

    public final void append(byte by) {
        this.ensureCapacity(this.getSize() + 1);
        int n = this.offset;
        this.offset = n + 1;
        this.buffer[n] = by;
    }

    public final void append(@NotNull byte[] array, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (!(startIndex <= endIndex)) {
            boolean bl = false;
            String string = "startIndex (" + startIndex + ") > endIndex (" + endIndex + ')';
            throw new IllegalArgumentException(string.toString());
        }
        if (startIndex < 0 || endIndex > array.length) {
            throw new IndexOutOfBoundsException("startIndex (" + startIndex + ") and endIndex (" + endIndex + ") represents an interval out of array's bounds [0.." + array.length + ").");
        }
        this.ensureCapacity(this.offset + endIndex - startIndex);
        ArraysKt.copyInto((byte[])array, (byte[])this.buffer, (int)this.offset, (int)startIndex, (int)endIndex);
        this.offset += endIndex - startIndex;
    }

    public static /* synthetic */ void append$default(ByteStringBuilder byteStringBuilder, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        byteStringBuilder.append(byArray, n, n2);
    }

    private final void ensureCapacity(int requiredCapacity) {
        if (this.buffer.length >= requiredCapacity) {
            return;
        }
        int desiredSize = this.buffer.length == 0 ? 16 : (int)((double)this.buffer.length * 1.5);
        desiredSize = Math.max(desiredSize, requiredCapacity);
        byte[] newBuffer = new byte[desiredSize];
        ArraysKt.copyInto$default((byte[])this.buffer, (byte[])newBuffer, (int)0, (int)0, (int)0, (int)14, null);
        this.buffer = newBuffer;
    }

    public ByteStringBuilder() {
        this(0, 1, null);
    }
}

