/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSink;
import kotlinx.io.Segment;
import kotlinx.io._UtilKt;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lkotlinx/io/OutputStreamSink;", "Lkotlinx/io/RawSink;", "Ljava/io/OutputStream;", "out", "<init>", "(Ljava/io/OutputStream;)V", "Lkotlinx/io/Buffer;", "source", "", "byteCount", "", "write", "(Lkotlinx/io/Buffer;J)V", "flush", "()V", "close", "", "toString", "()Ljava/lang/String;", "Ljava/io/OutputStream;", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nJvmCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCore.kt\nkotlinx/io/OutputStreamSink\n+ 2 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,112:1\n99#2:113\n100#2,2:115\n102#2,6:118\n1#3:114\n107#4:117\n*S KotlinDebug\n*F\n+ 1 JvmCore.kt\nkotlinx/io/OutputStreamSink\n*L\n48#1:113\n48#1:115,2\n48#1:118,6\n48#1:114\n49#1:117\n*E\n"})
class OutputStreamSink
implements RawSink {
    @NotNull
    private final OutputStream out;

    public OutputStreamSink(@NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull Buffer source, long byteCount) {
        int toCopy;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        _UtilKt.checkOffsetAndCount(source.getSize(), 0L, byteCount);
        long remaining = 0L;
        for (remaining = byteCount; remaining > 0L; remaining -= (long)toCopy) {
            void a$iv;
            void pos;
            void limit;
            Segment head$iv;
            UnsafeBufferOperations this_$iv = UnsafeBufferOperations.INSTANCE;
            boolean $i$f$readFromHead = false;
            if (!(!source.exhausted())) {
                boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
                String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
                throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
            }
            Intrinsics.checkNotNull((Object)source.getHead());
            int n = head$iv.getLimit();
            int n2 = head$iv.getPos();
            byte[] data = head$iv.dataAsByteArray(true);
            boolean bl = false;
            long l = remaining;
            void b$iv = limit - pos;
            boolean $i$f$minOf = false;
            toCopy = (int)Math.min((long)a$iv, (long)b$iv);
            this.out.write(data, (int)pos, toCopy);
            int bytesRead$iv = toCopy;
            if (bytesRead$iv == 0) continue;
            if (bytesRead$iv < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead$iv > head$iv.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            source.skip(bytesRead$iv);
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
    }

    @NotNull
    public String toString() {
        return "RawSink(" + this.out + ')';
    }
}

