/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2465;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4174;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralUtil {
    private static final String BLOCK_POS_KEY = "block_pos";
    private static final String BLOCK_POSES_KEY = "block_poses";
    public static final class_2754<LineConnectingType> LINE_CONNECTING_TYPE = class_2754.method_11850((String)"type", LineConnectingType.class);

    public static boolean isFullAndSolid(class_4538 levelReader, class_2338 blockPos) {
        return GeneralUtil.isFaceFull(levelReader, blockPos) && GeneralUtil.isSolid(levelReader, blockPos);
    }

    public static boolean isFaceFull(class_4538 levelReader, class_2338 blockPos) {
        class_2338 belowPos = blockPos.method_10074();
        return class_2248.method_9501((class_265)levelReader.method_8320(belowPos).method_26218((class_1922)levelReader, belowPos), (class_2350)class_2350.field_11036);
    }

    public static boolean isSolid(class_4538 levelReader, class_2338 blockPos) {
        return levelReader.method_8320(blockPos.method_10074()).method_51367();
    }

    public static boolean matchesRecipe(class_1263 inventory, class_2371<class_1856> recipe, int startIndex, int endIndex) {
        ArrayList<class_1799> validStacks = new ArrayList<class_1799>();
        for (int i = startIndex; i <= endIndex; ++i) {
            class_1799 stackInSlot = inventory.method_5438(i);
            if (stackInSlot.method_7960()) continue;
            validStacks.add(stackInSlot);
        }
        for (class_1856 entry : recipe) {
            boolean matches = false;
            for (class_1799 item : validStacks) {
                if (!entry.method_8093(item)) continue;
                matches = true;
                validStacks.remove(item);
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    public static class_2371<class_1856> deserializeIngredients(JsonArray json) {
        class_2371 ingredients = class_2371.method_10211();
        for (int i = 0; i < json.size(); ++i) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)json.get(i));
            if (ingredient.method_8103()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public static class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1082((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (class_247)class_247.field_1366);
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    public static void registerColorArmor(class_1792 item, int defaultColor) {
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> 0 < tintIndex ? 0xFFFFFF : GeneralUtil.getColor(stack, defaultColor), (class_1935[])new class_1935[]{item});
    }

    static int getColor(class_1799 itemStack, int defaultColor) {
        class_2487 displayTag = itemStack.method_7941("display");
        if (null != displayTag && displayTag.method_10573("color", 99)) {
            return displayTag.method_10550("color");
        }
        return defaultColor;
    }

    public static void spawnSlice(class_1937 level, class_1799 stack, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
        class_1542 entity = new class_1542(level, x, y, z, stack);
        entity.method_18800(xMotion, yMotion, zMotion);
        level.method_8649((class_1297)entity);
    }

    public static Collection<class_3222> tracking(class_3218 world, class_1923 pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.method_14178().field_17254.method_17210(pos, false);
    }

    public static Collection<class_3222> tracking(class_3218 world, class_2338 pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return GeneralUtil.tracking(world, new class_1923(pos));
    }

    public static float getInPercent(int i) {
        return (float)i / 100.0f;
    }

    public static class_1799 convertStackAfterFinishUsing(class_1309 entity, class_1799 used, class_1792 returnItem, class_1792 usedItem) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            class_174.field_1198.method_8821(serverPlayer, used);
            serverPlayer.method_7259(class_3468.field_15372.method_14956((Object)usedItem));
        }
        if (used.method_7960()) {
            return new class_1799((class_1935)returnItem);
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!((class_1657)entity).method_31549().field_7477) {
                class_1799 itemStack2 = new class_1799((class_1935)returnItem);
                if (!player.method_31548().method_7394(itemStack2)) {
                    player.method_7328(itemStack2, false);
                }
            }
        }
        return used;
    }

    public static class_1269 fillBucket(class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_1799 itemStack, class_1799 returnItem, class_2680 blockState, class_3414 soundEvent) {
        if (!level.field_9236) {
            class_1792 item = itemStack.method_7909();
            player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)returnItem));
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            level.method_8501(blockPos, blockState);
            level.method_8396(null, blockPos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            level.method_33596(null, class_5712.field_28167, blockPos);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public static class_1269 emptyBucket(class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_1799 itemStack, class_1799 returnItem, class_2680 blockState, class_3414 soundEvent) {
        if (!level.field_9236) {
            class_1792 item = itemStack.method_7909();
            player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)returnItem));
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            level.method_8501(blockPos, blockState);
            level.method_8396(null, blockPos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            level.method_33596(null, class_5712.field_28166, blockPos);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public static class_2465 logBlock() {
        return new class_2465(class_4970.class_2251.method_9630((class_4970)class_2246.field_10431));
    }

    public static boolean isDamageType(class_1282 source, List<class_5321<class_8110>> damageTypes) {
        for (class_5321<class_8110> key : damageTypes) {
            if (!source.method_49708(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFire(class_1282 source) {
        return GeneralUtil.isDamageType(source, List.of(class_8111.field_42337, class_8111.field_42335, class_8111.field_42325, class_8111.field_42324, class_8111.field_42326));
    }

    public static boolean isIndexInRange(int index, int startInclusive, int endInclusive) {
        return index >= startInclusive && index <= endInclusive;
    }

    public static class_2540 create() {
        return new class_2540(Unpooled.buffer());
    }

    public static void popResourceFromFace(class_1937 level, class_2338 blockPos, class_2350 side, class_1799 itemStack) {
        class_2680 blockState = level.method_8320(blockPos);
        double itemWidth = class_1299.field_6052.method_17685();
        double itemHeight = class_1299.field_6052.method_17686();
        class_265 shape = blockState.method_26220((class_1922)level, blockPos);
        double posX = (double)blockPos.method_10263() + 0.5;
        double posY = (double)blockPos.method_10264() + 0.5;
        double posZ = (double)blockPos.method_10260() + 0.5;
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        switch (side) {
            case field_11033: {
                posY = (double)blockPos.method_10264() - shape.method_1091(class_2350.class_2351.field_11052);
                offsetY = -itemHeight * 2.0;
                break;
            }
            case field_11036: {
                posY = (double)blockPos.method_10264() + shape.method_1105(class_2350.class_2351.field_11052);
                break;
            }
            case field_11043: {
                posZ = (double)blockPos.method_10260() + shape.method_1091(class_2350.class_2351.field_11051);
                offsetZ = -itemWidth;
                break;
            }
            case field_11035: {
                posZ = (double)blockPos.method_10260() + shape.method_1105(class_2350.class_2351.field_11051);
                offsetZ = itemWidth;
                break;
            }
            case field_11039: {
                posX = (double)blockPos.method_10263() + shape.method_1091(class_2350.class_2351.field_11048);
                offsetX = -itemWidth;
                break;
            }
            case field_11034: {
                posX = (double)blockPos.method_10263() + shape.method_1105(class_2350.class_2351.field_11048);
                offsetX = itemWidth;
            }
        }
        int i = side.method_10148();
        int j = side.method_10164();
        int k = side.method_10165();
        double deltaX = i == 0 ? class_3532.method_15366((class_5819)level.field_9229, (double)-0.1, (double)0.1) : (double)i * 0.1;
        double deltaY = j == 0 ? class_3532.method_15366((class_5819)level.field_9229, (double)0.0, (double)0.1) : (double)j * 0.1 + 0.1;
        double deltaZ = k == 0 ? class_3532.method_15366((class_5819)level.field_9229, (double)-0.1, (double)0.1) : (double)k * 0.1;
        GeneralUtil.popResource(level, new class_1542(level, posX + offsetX, posY + offsetY, posZ + offsetZ, itemStack, deltaX, deltaY, deltaZ), itemStack);
    }

    private static void popResource(class_1937 level, class_1542 itemEntity, class_1799 itemStack) {
        if (!level.field_9236 && !itemStack.method_7960() && level.method_8450().method_8355(class_1928.field_19392)) {
            itemEntity.method_6988();
            level.method_8649((class_1297)itemEntity);
        }
    }

    public static void putBlockPos(class_2487 compoundTag, class_2338 blockPos) {
        if (blockPos == null) {
            return;
        }
        int[] positions = new int[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()};
        compoundTag.method_10539(BLOCK_POS_KEY, positions);
    }

    public static void putBlockPoses(class_2487 compoundTag, Collection<class_2338> blockPoses) {
        if (blockPoses == null || blockPoses.isEmpty()) {
            return;
        }
        int[] positions = new int[blockPoses.size() * 3];
        int pos = 0;
        for (class_2338 blockPos : blockPoses) {
            positions[pos * 3] = blockPos.method_10263();
            positions[pos * 3 + 1] = blockPos.method_10264();
            positions[pos * 3 + 2] = blockPos.method_10260();
            ++pos;
        }
        compoundTag.method_10539(BLOCK_POSES_KEY, positions);
    }

    @Nullable
    public static class_2338 readBlockPos(class_2487 compoundTag) {
        if (!compoundTag.method_10545(BLOCK_POS_KEY)) {
            return null;
        }
        int[] positions = compoundTag.method_10561(BLOCK_POS_KEY);
        return new class_2338(positions[0], positions[1], positions[2]);
    }

    public static Set<class_2338> readBlockPoses(class_2487 compoundTag) {
        HashSet<class_2338> blockSet = new HashSet<class_2338>();
        if (!compoundTag.method_10545(BLOCK_POSES_KEY)) {
            return blockSet;
        }
        int[] positions = compoundTag.method_10561(BLOCK_POSES_KEY);
        for (int pos = 0; pos < positions.length / 3; ++pos) {
            blockSet.add(new class_2338(positions[pos * 3], positions[pos * 3 + 1], positions[pos * 3 + 2]));
        }
        return blockSet;
    }

    public static enum LineConnectingType implements class_3542
    {
        NONE("none"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private LineConnectingType(String type) {
            this.name = type;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }

    public static class FoodComponent
    extends class_4174 {
        public FoodComponent(List<Pair<class_1293, Float>> statusEffects) {
            super(1, 0.0f, false, true, false, statusEffects);
        }
    }
}

