/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.cristelknight.doapi.client.recipebook.handler.AbstractPrivateRecipeScreenHandler;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateAnimatedResultButton;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeAlternativesWidget;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeBookWidget;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_361;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PrivateRecipeBookRecipeArea {
    private final List<PrivateAnimatedResultButton> resultButtons = Lists.newArrayListWithCapacity((int)20);
    @Nullable
    private PrivateAnimatedResultButton hoveredResultButton;
    private final PrivateRecipeAlternativesWidget alternatesWidget = new PrivateRecipeAlternativesWidget();
    private class_310 client;
    private List<? extends class_1860<class_1263>> resultCollections = ImmutableList.of();
    private class_361 nextPageButton;
    private class_361 prevPageButton;
    private int pageCount;
    private int currentPage;
    @Nullable
    private class_1860<?> lastClickedRecipe;
    private AbstractPrivateRecipeScreenHandler recipeScreenHandler;

    public PrivateRecipeBookRecipeArea() {
        for (int i = 0; i < 20; ++i) {
            this.resultButtons.add(new PrivateAnimatedResultButton());
        }
    }

    public void initialize(class_310 client, int parentLeft, int parentTop, AbstractPrivateRecipeScreenHandler recipeScreenHandler) {
        this.client = client;
        this.recipeScreenHandler = recipeScreenHandler;
        for (int i = 0; i < this.resultButtons.size(); ++i) {
            this.resultButtons.get(i).setPos(parentLeft + 11 + 25 * (i % 5), parentTop + 31 + 25 * (i / 5));
        }
        this.nextPageButton = new class_361(parentLeft + 93, parentTop + 137, 12, 17, false);
        this.nextPageButton.method_1962(1, 208, 13, 18, PrivateRecipeBookWidget.TEXTURE);
        this.prevPageButton = new class_361(parentLeft + 38, parentTop + 137, 12, 17, true);
        this.prevPageButton.method_1962(1, 208, 13, 18, PrivateRecipeBookWidget.TEXTURE);
    }

    public void setResults(List<? extends class_1860<class_1263>> resultCollections, boolean resetCurrentPage) {
        this.resultCollections = resultCollections;
        this.pageCount = (int)Math.ceil((double)resultCollections.size() / 20.0);
        if (this.pageCount <= this.currentPage || resetCurrentPage) {
            this.currentPage = 0;
        }
        this.refreshResultButtons();
    }

    private void refreshResultButtons() {
        int i = 20 * this.currentPage;
        for (int j = 0; j < this.resultButtons.size(); ++j) {
            PrivateAnimatedResultButton animatedResultButton = this.resultButtons.get(j);
            if (i + j < this.resultCollections.size()) {
                class_1860<class_1263> recipe = this.resultCollections.get(i + j);
                animatedResultButton.showResultCollection(recipe, this.recipeScreenHandler);
                animatedResultButton.field_22764 = true;
                continue;
            }
            animatedResultButton.field_22764 = false;
        }
        this.hideShowPageButtons();
    }

    private void hideShowPageButtons() {
        this.nextPageButton.field_22764 = this.pageCount > 1 && this.currentPage < this.pageCount - 1;
        this.prevPageButton.field_22764 = this.pageCount > 1 && this.currentPage > 0;
    }

    public void draw(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float delta) {
        if (this.pageCount > 1) {
            int var10000 = this.currentPage + 1;
            String string = var10000 + "/" + this.pageCount;
            int i = this.client.field_1772.method_1727(string);
            guiGraphics.method_51433(this.client.field_1772, string, x - i / 2 + 73, y + 141, -1, false);
        }
        this.hoveredResultButton = null;
        for (PrivateAnimatedResultButton animatedResultButton : this.resultButtons) {
            animatedResultButton.method_25394(guiGraphics, mouseX, mouseY, delta);
            if (!animatedResultButton.field_22764 || !animatedResultButton.method_25367()) continue;
            this.hoveredResultButton = animatedResultButton;
        }
        this.prevPageButton.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.nextPageButton.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.alternatesWidget.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public void drawTooltip(class_332 guiGraphics, int x, int y) {
        if (this.client.field_1755 != null && this.hoveredResultButton != null && !this.alternatesWidget.isVisible()) {
            guiGraphics.method_51434(this.client.field_1772, this.hoveredResultButton.getOutputTooltip(), x, y);
        }
    }

    @Nullable
    public class_1860<?> getLastClickedRecipe() {
        return this.lastClickedRecipe;
    }

    public void hideAlternates() {
        this.alternatesWidget.setVisible(false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        PrivateAnimatedResultButton animatedResultButton;
        this.lastClickedRecipe = null;
        if (this.alternatesWidget.isVisible()) {
            if (this.alternatesWidget.method_25402(mouseX, mouseY, button)) {
                this.lastClickedRecipe = this.alternatesWidget.getLastClickedRecipe();
            } else {
                this.alternatesWidget.setVisible(false);
            }
            return true;
        }
        if (this.nextPageButton.method_25402(mouseX, mouseY, button)) {
            ++this.currentPage;
            this.refreshResultButtons();
            return true;
        }
        if (this.prevPageButton.method_25402(mouseX, mouseY, button)) {
            --this.currentPage;
            this.refreshResultButtons();
            return true;
        }
        Iterator<PrivateAnimatedResultButton> var10 = this.resultButtons.iterator();
        do {
            if (var10.hasNext()) continue;
            return false;
        } while (!(animatedResultButton = var10.next()).method_25402(mouseX, mouseY, button));
        if (button == 0) {
            this.lastClickedRecipe = animatedResultButton.currentRecipe();
        }
        if (button != 1 || this.alternatesWidget.isVisible() || animatedResultButton.hasResult()) {
            // empty if block
        }
        return true;
    }

    public class_310 getClient() {
        return this.client;
    }
}

